package gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;

/**
 * @author wijnand.schepens@hogent.be
 */
public class Chronometer extends JFrame implements ActionListener {
    public static void main(String args[]) {

		try {
			UIManager.setLookAndFeel(
            UIManager.getSystemLookAndFeelClassName());
		}
		catch (Exception e) {
		   System.err.println("kan look-and-feel niet instellen");
		}

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Chronometer().setVisible(true);
            }
        });
    }
	
    public Chronometer()
	{
		initComponents();

		timer = new Timer( 10, this);
	}

	private void initComponents()
	{
		tijdLabel = new JLabel();
        tijdLabel.setFont(new java.awt.Font("Book Antiqua", 0, 36));
        tijdLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        tijdLabel.setText("00:00:00");

        rondeLijst = new JTextArea();
		rondeLijst.setColumns(10);
        rondeLijst.setEditable(false);
        rondeLijst.setRows(5);
        
        startOfRondeKnop = new JButton();
		startOfRondeKnop.setText("start");
        startOfRondeKnop.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                startOfRondeKnopActionPerformed(evt);
            }
        });

        stopOfResetKnop = new JButton();
		stopOfResetKnop.setText("stop");
        stopOfResetKnop.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                stopOfResetKnopActionPerformed(evt);
            }
        });

		JPanel knoppenPaneel = new JPanel();
		knoppenPaneel.add(startOfRondeKnop);
		knoppenPaneel.add(stopOfResetKnop);

        JPanel paneel = new JPanel();
		paneel.setLayout(new BorderLayout());
		paneel.add(tijdLabel, BorderLayout.NORTH);
		JScrollPane rondePaneel = new JScrollPane();
        rondePaneel.setViewportView(rondeLijst);
		paneel.add(rondePaneel, BorderLayout.CENTER);
		paneel.add(knoppenPaneel, BorderLayout.SOUTH);

		setContentPane(paneel);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        //setResizable(false);
        pack();
		reset();
		setLocationRelativeTo(null);	// window centreren
    }
	

	private void startOfRondeKnopActionPerformed(ActionEvent evt)
	{
		if (timer.isRunning())
			ronde();
		else
			start();
}

	private void stopOfResetKnopActionPerformed(ActionEvent evt)
	{
		if (timer.isRunning())
			stop();
		else
			reset();
	}

	public void actionPerformed(ActionEvent e)		// timer tick
	{
		tijd = laatsteStopTijd + (int)(getSysteemTijdInHonderdsten() - startTijd);
		updateTijdLabel();
	}

	public void start()
	{
		startTijd = getSysteemTijdInHonderdsten();
		timer.start();
		startOfRondeKnop.setText("ronde");
		stopOfResetKnop.setText("stop");
		stopOfResetKnop.setVisible(true);
	}

	public void stop()
	{
		timer.stop();
		laatsteStopTijd = tijd;
		updateTijdLabel();
		startOfRondeKnop.setText("start");
		stopOfResetKnop.setText("reset");
	}

	public void ronde()
	{
		voegRondeToe(tijdLabel.getText());
	}

	public void reset()
	{
		laatsteStopTijd = 0;
		tijd = 0;
		startOfRondeKnop.setText("start");
		stopOfResetKnop.setVisible(false);
		updateTijdLabel();
		wisRondeLijst();
	}


	public void wisRondeLijst()
	{
		rondeLijst.setText("");
	}

	public void voegRondeToe(String s)
	{
		if (rondeLijst.getText().isEmpty())
			rondeLijst.setText(s);
		else
			rondeLijst.setText(rondeLijst.getText() + "\n" + s);
	}

	public void updateTijdLabel()
	{
		tijdLabel.setText(formatMMSShh(tijd));
	}

	public static long getSysteemTijdInHonderdsten()
	{
		//return (new Date()).getTime() / 10;
		return System.nanoTime() / 10000000L;
	}

	public static String formatMMSShh(int t)	// t in ms
	{
		StringBuilder sb = new StringBuilder();
		int hh = t%100;	// honderdsten
		t /= 100;
		int ss = t%60;
		t /= 60;
		int mm = t%60;
		// hours = t/60 ...
		if (mm<10)
			sb.append("0");
		sb.append(mm).append(":");
		if (ss<10)
			sb.append("0");
		sb.append(ss).append(":");
		if (hh<10)
			sb.append("0");
		sb.append(hh);
		return sb.toString();
	}


    private JTextArea rondeLijst;
    private JButton startOfRondeKnop;
    private JButton stopOfResetKnop;
    private JLabel tijdLabel;
	private Timer timer;
	private long  startTijd; // uit Date
	private int   laatsteStopTijd;
	private int   tijd;
}
