/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;

public class Chronometer
extends JFrame
implements ActionListener {
    private JTextArea rondeLijst;
    private JButton startOfRondeKnop;
    private JButton stopOfResetKnop;
    private JLabel tijdLabel;
    private Timer timer;
    private long startTijd;
    private int laatsteStopTijd;
    private int tijd;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("kan look-and-feel niet instellen");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Chronometer().setVisible(true);
            }
        });
    }

    public Chronometer() {
        this.initComponents();
        this.timer = new Timer(10, this);
    }

    private void initComponents() {
        this.tijdLabel = new JLabel();
        this.tijdLabel.setFont(new Font("Book Antiqua", 0, 36));
        this.tijdLabel.setHorizontalAlignment(0);
        this.tijdLabel.setText("00:00:00");
        this.rondeLijst = new JTextArea();
        this.rondeLijst.setColumns(10);
        this.rondeLijst.setEditable(false);
        this.rondeLijst.setRows(5);
        this.startOfRondeKnop = new JButton();
        this.startOfRondeKnop.setText("start");
        this.startOfRondeKnop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Chronometer.this.startOfRondeKnopActionPerformed(evt);
            }
        });
        this.stopOfResetKnop = new JButton();
        this.stopOfResetKnop.setText("stop");
        this.stopOfResetKnop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Chronometer.this.stopOfResetKnopActionPerformed(evt);
            }
        });
        JPanel knoppenPaneel = new JPanel();
        knoppenPaneel.add(this.startOfRondeKnop);
        knoppenPaneel.add(this.stopOfResetKnop);
        JPanel paneel = new JPanel();
        paneel.setLayout(new BorderLayout());
        paneel.add((Component)this.tijdLabel, "North");
        JScrollPane rondePaneel = new JScrollPane();
        rondePaneel.setViewportView(this.rondeLijst);
        paneel.add((Component)rondePaneel, "Center");
        paneel.add((Component)knoppenPaneel, "South");
        this.setContentPane(paneel);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.reset();
        this.setLocationRelativeTo(null);
    }

    private void startOfRondeKnopActionPerformed(ActionEvent evt) {
        if (this.timer.isRunning()) {
            this.ronde();
        } else {
            this.start();
        }
    }

    private void stopOfResetKnopActionPerformed(ActionEvent evt) {
        if (this.timer.isRunning()) {
            this.stop();
        } else {
            this.reset();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.tijd = this.laatsteStopTijd + (int)(Chronometer.getSysteemTijdInHonderdsten() - this.startTijd);
        this.updateTijdLabel();
    }

    public void start() {
        this.startTijd = Chronometer.getSysteemTijdInHonderdsten();
        this.timer.start();
        this.startOfRondeKnop.setText("ronde");
        this.stopOfResetKnop.setText("stop");
        this.stopOfResetKnop.setVisible(true);
    }

    public void stop() {
        this.timer.stop();
        this.laatsteStopTijd = this.tijd;
        this.updateTijdLabel();
        this.startOfRondeKnop.setText("start");
        this.stopOfResetKnop.setText("reset");
    }

    public void ronde() {
        this.voegRondeToe(this.tijdLabel.getText());
    }

    public void reset() {
        this.laatsteStopTijd = 0;
        this.tijd = 0;
        this.startOfRondeKnop.setText("start");
        this.stopOfResetKnop.setVisible(false);
        this.updateTijdLabel();
        this.wisRondeLijst();
    }

    public void wisRondeLijst() {
        this.rondeLijst.setText("");
    }

    public void voegRondeToe(String s) {
        if (this.rondeLijst.getText().isEmpty()) {
            this.rondeLijst.setText(s);
        } else {
            this.rondeLijst.setText(this.rondeLijst.getText() + "\n" + s);
        }
    }

    public void updateTijdLabel() {
        this.tijdLabel.setText(Chronometer.formatMMSShh(this.tijd));
    }

    public static long getSysteemTijdInHonderdsten() {
        return System.nanoTime() / 10000000L;
    }

    public static String formatMMSShh(int t) {
        StringBuilder sb = new StringBuilder();
        int hh = t % 100;
        int ss = (t /= 100) % 60;
        int mm = (t /= 60) % 60;
        if (mm < 10) {
            sb.append("0");
        }
        sb.append(mm).append(":");
        if (ss < 10) {
            sb.append("0");
        }
        sb.append(ss).append(":");
        if (hh < 10) {
            sb.append("0");
        }
        sb.append(hh);
        return sb.toString();
    }
}

