/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnaloogUurwerk
extends JPanel {
    public AnaloogUurwerk() {
        this.setPreferredSize(new Dimension(400, 400));
        this.setBackground(new Color(180, 180, 0));
        new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnaloogUurwerk.this.repaint();
            }
        }).start();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Calendar c = Calendar.getInstance();
        int uur = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        this.teken(g2, uur, min, sec);
    }

    private void teken(Graphics2D g2, int uur, int min, int sec) {
        int t;
        int straal = Math.min(this.getWidth(), this.getHeight()) / 2 - 1;
        g2.translate(straal + 1, straal + 1);
        g2.setColor(Color.WHITE);
        g2.fillOval(-straal, -straal, 2 * straal, 2 * straal);
        for (t = 0; t < 60; ++t) {
            this.tekenStraal(g2, t * 6, (double)straal * 0.97, straal, 0.5, Color.GRAY);
        }
        g2.setFont(new Font("Serif", 1, (int)(15.0f * (float)straal / 100.0f)));
        for (t = 1; t <= 12; ++t) {
            this.tekenStraal(g2, t * 30, (double)straal * 0.9, straal, 0.5, Color.GRAY);
            this.tekenTekst(g2, t * 30, "" + t, (double)straal * 0.8, Color.GRAY);
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawOval(-straal, -straal, 2 * straal, 2 * straal);
        this.tekenStraal(g2, (double)(uur * 30) + (double)min / 2.0, 0.0, (double)straal * 0.6, 2.0, Color.BLACK);
        this.tekenStraal(g2, (double)(min * 6) + (double)sec / 10.0, 0.0, (double)straal * 0.9, 1.0, Color.BLACK);
        this.tekenStraal(g2, sec * 6, 0.0, (double)straal * 0.9, 1.0, Color.RED);
    }

    private void tekenStraal(Graphics2D g2, double hoek, double startLengte, double stopLengte, double dikte, Color kleur) {
        g2.setColor(kleur);
        g2.setStroke(new BasicStroke((float)dikte));
        double hoekRad = (-90.0 + hoek) * Math.PI / 180.0;
        double cos = Math.cos(hoekRad);
        double sin = Math.sin(hoekRad);
        g2.drawLine((int)(cos * startLengte), (int)(sin * startLengte), (int)(cos * stopLengte), (int)(sin * stopLengte));
    }

    private void tekenTekst(Graphics2D g2, double hoek, String tekst, double afstand, Color kleur) {
        g2.setColor(kleur);
        double hoekRad = (-90.0 + hoek) * Math.PI / 180.0;
        double x = Math.cos(hoekRad) * afstand;
        double y = Math.sin(hoekRad) * afstand;
        Rectangle2D rect = AnaloogUurwerk.getBounds2D(g2, g2.getFont(), tekst);
        double tb = rect.getWidth();
        double th = rect.getHeight();
        g2.drawString(tekst, (float)(x - tb / 2.0), (float)(y + th / 2.0));
    }

    public static Rectangle2D getBounds2D(Graphics2D g2, Font font, String tekst) {
        FontRenderContext frc = g2.getFontRenderContext();
        if (tekst == null || tekst.length() == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        TextLayout tl = new TextLayout(tekst, font, frc);
        Shape outline = tl.getOutline(null);
        return outline.getBounds2D();
    }
}

