// Action2v2.java 

import java.awt.event.*;
import javax.swing.*;
import java.awt.Color;   

class Action2v2 extends JPanel implements ActionListener{
  private JTextField kleur;
  private JButton knopR,knopG,knopB;
  private int rood, groen, blauw;

  Action2v2() {
    knopR = new JButton ("R + 32");
    knopR.addActionListener(this);
  
    knopG = new JButton ("G + 32");
    knopG.addActionListener(this);

    knopB = new JButton ("B + 32");
    knopB.addActionListener(this);

    kleur = new JTextField(10);
    kleur.setEditable(false);
    kleur.setBackground(new Color(0,0,0));
    rood = 0; groen = 0; blauw = 0;

    add(knopR);
    add(knopG);
    add(knopB);
    add(kleur);
  }

  public void actionPerformed (ActionEvent e){
    JButton knop = (JButton)e.getSource();
    if (knop==knopR) rood = (rood+32) % 256;
    else if (knop==knopG) groen = (groen+32) % 256;
    else blauw = (blauw+32) % 256;
    kleur.setBackground(new Color(rood,groen,blauw));
  }

  public static void main (String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame ("Action2v2");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new Action2v2());
        venster.setLocationRelativeTo(null);	
        venster.pack();
        venster.setVisible(true);
    }});
  }
}