// Mouse2v1.java 

import java.awt.event.*;
import javax.swing.*;

class Mouse2v1 extends JPanel implements ActionListener {
  private JTextField tekst;

  Mouse2v1() {
    JButton knop = new JButton ("Klik");
    knop.addMouseListener(new MouseAdapter() {
      @Override
      public void mouseEntered(MouseEvent e) {
        tekst.setText("Klik op de knop");
      }
      public void mouseExited(MouseEvent e) {
        tekst.setText("Ga naar de knop");
      }
    });
    knop.addActionListener(this);

    tekst = new JTextField("Ga naar de knop");
    tekst.setEditable(false);

    add(knop);
    add(tekst);
  }

  public void actionPerformed(ActionEvent e) {
    JOptionPane.showMessageDialog(this,"Je hebt op de knop geklikt"); 
    tekst.setText("Ga naar de knop");
  }
   
  public static void main (String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame ("Mouse2v1");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new Mouse2v1());
        venster.setLocationRelativeTo(null);	
        venster.pack();
        venster.setVisible(true);
    }});
  }
}