// BorderDemo.java
// grotendeels overgenomen uit de tutorial

import java.awt.*;
import java.awt.event.*;
import javax.swing.*; 
import javax.swing.border.*;

class BorderDemo extends JTabbedPane {

  BorderDemo() {      
    Border paneEdge = BorderFactory.createEmptyBorder(0,10,10,10);
    Border blackline = BorderFactory.createLineBorder(Color.black);
    Border raisedetched = BorderFactory.createEtchedBorder(EtchedBorder.RAISED);
    Border loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
    Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    Border loweredbevel = BorderFactory.createLoweredBevelBorder();
    Border empty = BorderFactory.createEmptyBorder();

    //First pane: simple borders
    JPanel simpleBorders = new JPanel();
    simpleBorders.setBorder(paneEdge);
    simpleBorders.setLayout(new BoxLayout(simpleBorders,BoxLayout.Y_AXIS));
    addCompForBorder(blackline, "line border",simpleBorders);
    addCompForBorder(raisedetched, "raised etched border",simpleBorders);
    addCompForBorder(loweredetched, "lowered etched border",simpleBorders);
    addCompForBorder(raisedbevel, "raised bevel border",simpleBorders);
    addCompForBorder(loweredbevel, "lowered bevel border",simpleBorders);
    addCompForBorder(empty, "empty border",simpleBorders);

    //Second pane: matte borders
    JPanel matteBorders = new JPanel();
    matteBorders.setBorder(paneEdge);
    matteBorders.setLayout(new BoxLayout(matteBorders,BoxLayout.Y_AXIS));
    ImageIcon icon = new ImageIcon("images/wavy.gif","wavy-line border icon"); 
    Border border = BorderFactory.createMatteBorder(-1, -1, -1, -1, icon);
    addCompForBorder(border,"matte border (-1,-1,-1,-1,icon)",matteBorders);
    border = BorderFactory.createMatteBorder(1, 5, 1, 1, Color.red);
    addCompForBorder(border,"matte border (1,5,1,1,Color.red)",matteBorders);
    border = BorderFactory.createMatteBorder(0, 20, 0, 0, icon);
    addCompForBorder(border,"matte border (0,20,0,0,icon)",matteBorders);

    //Third pane: titled borders
    JPanel titledBorders = new JPanel();
    titledBorders.setBorder(paneEdge);
    titledBorders.setLayout(new BoxLayout(titledBorders,BoxLayout.Y_AXIS));
    TitledBorder titled = BorderFactory.createTitledBorder("title");
    addCompForBorder(titled,"default titled border (default just., default pos.)",
                     titledBorders);
    titled = BorderFactory.createTitledBorder(blackline, "title");
    addCompForTitledBorder(titled,"titled line border (centered, default pos.)",
                           TitledBorder.CENTER,TitledBorder.DEFAULT_POSITION,titledBorders);
    titled = BorderFactory.createTitledBorder(loweredetched, "title");
    addCompForTitledBorder(titled,"titled lowered etched border (right just., default pos.)",
                           TitledBorder.RIGHT,TitledBorder.DEFAULT_POSITION,titledBorders);
    titled = BorderFactory.createTitledBorder(loweredbevel, "title");
    addCompForTitledBorder(titled,"titled lowered bevel border (default just., above top)",
                           TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.ABOVE_TOP,titledBorders);
    titled = BorderFactory.createTitledBorder(empty, "title");
    addCompForTitledBorder(titled, "titled empty border (default just., bottom)",
                           TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.BOTTOM,titledBorders);

    //Fourth pane: compound borders
    JPanel compoundBorders = new JPanel();
    compoundBorders.setBorder(paneEdge);
    compoundBorders.setLayout(new BoxLayout(compoundBorders,BoxLayout.Y_AXIS));
    Border redline = BorderFactory.createLineBorder(Color.red);
    Border compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
    addCompForBorder(compound, "compound border (two bevels)",compoundBorders);
    compound = BorderFactory.createCompoundBorder(redline, compound);
    addCompForBorder(compound, "compound border (add a red outline)",compoundBorders);
    titled = BorderFactory.createTitledBorder(compound, "title",
                                              TitledBorder.CENTER,TitledBorder.BELOW_BOTTOM);
    addCompForBorder(titled,"titled compound border (centered, below bottom)",compoundBorders);

    addTab("Simple", null, simpleBorders, null);
    addTab("Matte", null, matteBorders, null);
    addTab("Titled", null, titledBorders, null);
    addTab("Compound", null, compoundBorders, null);
    setSelectedIndex(0);
  }

  void addCompForTitledBorder(TitledBorder border,String description,
                              int justification,int position,Container container) {
    border.setTitleJustification(justification);
    border.setTitlePosition(position);
    addCompForBorder(border, description,container);
  }

  void addCompForBorder(Border border,String description,Container container) {
    JPanel comp = new JPanel(new GridLayout(1, 1), false);
    JLabel label = new JLabel(description, JLabel.CENTER);
    comp.add(label);
    comp.setBorder(border);
    container.add(Box.createRigidArea(new Dimension(0, 10)));
    container.add(comp);
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("BorderDemo");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new BorderDemo());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
