//CardLayoutVoorbeeld.java
//Voorbeeld grotendeels overgenomen uit de tutorial

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class CardLayoutVoorbeeld extends JPanel implements ActionListener {

  private JPanel cards; 
  private JComboBox cb;
  private CardLayout cl;

  CardLayoutVoorbeeld() {
    String comboBoxItems[] = {"Knoppenpaneel", "Tekstveldpaneel"};
    cb = new JComboBox(comboBoxItems);
    cb.setEditable(false);
    cb.addActionListener(this);

    JPanel card1 = new JPanel();
    card1.add(new JButton("Knop 1"));
    card1.add(new JButton("Knop 2"));
    card1.add(new JButton("Knop 3"));

    JPanel card2 = new JPanel();
    card2.add(new JTextField("", 20));

    cl = new CardLayout();
    cards = new JPanel(cl);
    cards.add(card1, comboBoxItems[0]);
    cards.add(card2, comboBoxItems[1]);
      
    setLayout(new BorderLayout());
    add(cb, BorderLayout.NORTH);
    add(cards, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent e) {
    cl.show(cards, (String)cb.getSelectedItem());
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Voorbeeld CardLayout");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new CardLayoutVoorbeeld());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}    