import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;

class TekenCirkel1 extends JPanel {
  static final int STRAAL = 15;
  private int cirkelX, cirkelY;  //middelpunt huidige cirkel

  TekenCirkel1() {
    setPreferredSize(new Dimension(400,400));
    setBorder(BorderFactory.createLineBorder(Color.black,2));
    cirkelX = 200; cirkelY = 200;
    addMouseListener(new MouseAdapter() {
       public void mouseClicked(MouseEvent e) { 
          if (SwingUtilities.isLeftMouseButton(e)) {
             cirkelX = e.getX();
             cirkelY = e.getY();
             repaint();
          } 
    }});
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);  
    g.setColor(Color.red);
    g.fillOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL,2*STRAAL);
    g.setColor(Color.black);
    g.drawOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL-1,2*STRAAL-1);       
  } 

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("TekenCirkel1");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new TekenCirkel1());
        venster.pack();
        venster.setLocationRelativeTo(null);
        venster.setVisible(true);
    }});
  }
}