import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;

class TekenCirkel2 extends JPanel implements MouseListener, MouseMotionListener {
  static final int STRAAL = 15;
  private int cirkelX, cirkelY;
  private boolean versleep;

  TekenCirkel2() {
    setPreferredSize(new Dimension(400,400));
    setBorder(BorderFactory.createLineBorder(Color.black,2));
    cirkelX = 200;  cirkelY = 200;
    addMouseListener(this);
    addMouseMotionListener(this);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);  
    g.setColor(Color.red);
    g.fillOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL,2*STRAAL);
    g.setColor(Color.black);
    g.drawOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL-1,2*STRAAL-1);       
  } 

  public void mouseExited(MouseEvent e) {}   
  public void mouseEntered(MouseEvent e) {} 
  public void mousePressed(MouseEvent e) { 
    if (SwingUtilities.isLeftMouseButton(e)) {
      int afstX = cirkelX - e.getX();
      int afstY = cirkelY - e.getY();
      if (afstX*afstX + afstY*afstY <= STRAAL*STRAAL) {  
        versleep = true;
        cirkelX = e.getX();
        cirkelY = e.getY();
        repaint();
      }
      else 
        versleep = false;
    }
  }   
  public void mouseReleased(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e) && versleep) {
      cirkelX = e.getX();
      cirkelY = e.getY();
      repaint();     
    }
  } 
  public void mouseClicked(MouseEvent e) {}

  public void mouseMoved(MouseEvent e) {}
  public void mouseDragged(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e) && versleep) {
      cirkelX = e.getX();
      cirkelY = e.getY();
      repaint();     
    }
  } 
 
  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("TekenCirkel2");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new TekenCirkel2());
        venster.pack();
        venster.setLocationRelativeTo(null);
        venster.setVisible(true);
    }});
  }
}