import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.ArrayList;

class TekenCirkels extends JPanel implements MouseListener {
  static final int STRAAL = 15;
  private ArrayList<Point> punten;

  TekenCirkels() {
    punten = new ArrayList<Point>();
    setPreferredSize(new Dimension(400,400));
    setBorder(BorderFactory.createLineBorder(Color.black,2));
    addMouseListener(this);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    for (int i=0; i<punten.size(); i++) {
      int posX = punten.get(i).x;
      int posY = punten.get(i).y;  
      g.setColor(Color.blue);
      g.fillOval(posX-STRAAL,posY-STRAAL,2*STRAAL,2*STRAAL);
      g.setColor(Color.black);
      g.drawOval(posX-STRAAL,posY-STRAAL,2*STRAAL-1,2*STRAAL-1);   
    }
  } 

  public void mouseExited(MouseEvent e) {}   
  public void mouseEntered(MouseEvent e) {} 
  public void mousePressed(MouseEvent e) {} 
  public void mouseReleased(MouseEvent e) {} 
  public void mouseClicked(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e)) {
      int muisX = e.getX();
      int muisY = e.getY();  
      Graphics g = getGraphics();
      g.setColor(Color.blue);
      g.fillOval(muisX-STRAAL,muisY-STRAAL,2*STRAAL,2*STRAAL);
      g.setColor(Color.black);
      g.drawOval(muisX-STRAAL,muisY-STRAAL,2*STRAAL-1,2*STRAAL-1);   
      punten.add(new Point(muisX,muisY));
    }
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("TekenCirkels");              
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new TekenCirkels());
        venster.setLocationRelativeTo(null);
        venster.pack();  
        venster.setVisible(true);
    }});
  }
}
