import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;

class TekenImage extends JPanel implements MouseListener {
  static final int STRAAL = 15;
  private Image buf;
  private Graphics gbuf;

  TekenImage() {
    setPreferredSize(new Dimension(400,400));
    setBorder(BorderFactory.createLineBorder(Color.black,2));
    addMouseListener(this);    
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g); 
    if (buf == null) {
       Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
       buf = createImage((int)screenSize.getWidth(),(int)screenSize.getHeight());
       gbuf = buf.getGraphics();   
    }  
    g.drawImage(buf,0,0,this);
  } 

  public void mouseExited(MouseEvent e) {}   
  public void mouseEntered(MouseEvent e) {} 
  public void mousePressed(MouseEvent e) {} 
  public void mouseReleased(MouseEvent e) {} 
  public void mouseClicked(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e)) {
      int muisX = e.getX();
      int muisY = e.getY();
      gbuf.setColor(Color.blue);
      gbuf.fillOval(muisX-STRAAL,muisY-STRAAL,2*STRAAL,2*STRAAL);
      gbuf.setColor(Color.black);
      gbuf.drawOval(muisX-STRAAL,muisY-STRAAL,2*STRAAL-1,2*STRAAL-1);   
      repaint();
    }
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Tekenen op een Image");              
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new TekenImage());
        venster.setLocationRelativeTo(null);
        venster.pack();  
        venster.setVisible(true);
    }});
  }
}
