import javax.swing.border.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class TekenPaneela extends JPanel {
 
  static final int STRAAL = 15;
  private int cirkelX, cirkelY; 
  private InhoudsPaneela ip;
  
  TekenPaneela(InhoudsPaneela _ip) {
    ip = _ip;

    setPreferredSize(new Dimension(400,400));
    Border lijn = BorderFactory.createLineBorder(Color.black,2);
    Border leeg = BorderFactory.createEmptyBorder(2,2,5,2);
    setBorder(BorderFactory.createCompoundBorder(leeg,lijn));
    cirkelX = 200;  
    cirkelY = 200;
    addMouseListener(new MouseAdapter() {
       public void mouseClicked(MouseEvent e) { 
          if (SwingUtilities.isLeftMouseButton(e)) {
             cirkelX = e.getX();
             cirkelY = e.getY();
             repaint();
             ip.setTextLabel("  Positie cirkel : (" + cirkelX + "," + cirkelY + ")");
          } 
    }});
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);  
    g.setColor(Color.red);
    g.fillOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL,2*STRAAL);
    g.setColor(Color.black);
    g.drawOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL-1,2*STRAAL-1);  
  } 
}