import javax.swing.border.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class TekenPaneelb extends JPanel {
 
  static final int STRAAL = 15;
  private int cirkelX, cirkelY; 
  private InhoudsPaneelb ip;
  
  TekenPaneelb(InhoudsPaneelb _ip) {
    ip = _ip;

    setPreferredSize(new Dimension(400,400));
    Border lijn = BorderFactory.createLineBorder(Color.black,2);
    Border leeg = BorderFactory.createEmptyBorder(2,2,5,2);
    setBorder(BorderFactory.createCompoundBorder(leeg,lijn));
    cirkelX = 200;  
    cirkelY = 200;
    addMouseListener(new MouseAdapter() {
       public void mouseClicked(MouseEvent e) { 
          if (SwingUtilities.isLeftMouseButton(e)) {
             int muisX = e.getX();
             int muisY = e.getY();
             Insets rand = getInsets();
             if (muisX>=rand.left+STRAAL && muisX<=getWidth()-rand.right-STRAAL &&
                 muisY>=rand.top+STRAAL && muisY<=getHeight()-rand.bottom-STRAAL) {   
                cirkelX = muisX;
                cirkelY = muisY;
                repaint();
                ip.setLabelText("  Positie cirkel : (" + cirkelX + "," + cirkelY + ")");
             }
          }
    }});
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);  
    g.setColor(Color.red);
    g.fillOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL,2*STRAAL);
    g.setColor(Color.black);
    g.drawOval(cirkelX-STRAAL,cirkelY-STRAAL,2*STRAAL-1,2*STRAAL-1);  
  } 
}