import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

class TimerPaneel extends JPanel implements ActionListener {

  private Color[] kleuren;
  private int huidigkleur;

  private Timer timer;
    
  TimerPaneel() {
    setPreferredSize(new Dimension(150,150));
    Border lijn = BorderFactory.createLineBorder(Color.black,2);
    Border leeg = BorderFactory.createEmptyBorder(2,2,5,2);
    setBorder(BorderFactory.createCompoundBorder(leeg,lijn));

    kleuren = new Color[3];
    kleuren[0] = Color.red;
    kleuren[1] = Color.blue;
    kleuren[2] = Color.green;
    huidigkleur = 0;

    timer = new Timer (1000, this);
  }

  void start() {
    timer.start();
  }

  void stop() {
    timer.stop();
  }

  public void actionPerformed (ActionEvent e) {
    huidigkleur = (huidigkleur+1)%3;
    repaint();
  }

  public void paintComponent (Graphics g) {
    super.paintComponent(g);
    g.setColor(kleuren[huidigkleur]);
    g.fillOval(getWidth()/2-20,getHeight()/2-20,40,40);
    g.setColor(Color.black);
    g.drawOval(getWidth()/2-20,getHeight()/2-20,39,39);
  } 
}