import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

class TimerVb extends JPanel implements ActionListener {

  private JButton Tstart,Tstop;
  private TimerPaneel p;

  TimerVb() {
    setLayout(new BorderLayout());
    p = new TimerPaneel();
    add(p,BorderLayout.CENTER);    
    Tstart = new JButton("Start");
    Tstart.addActionListener(this);
    Tstop = new JButton("Stop");
    Tstop.addActionListener(this);
    Tstop.setEnabled(false);
    JPanel onder = new JPanel();
    onder.setLayout(new BoxLayout(onder,BoxLayout.X_AXIS));
    onder.add(Box.createHorizontalGlue());
    onder.add(Tstart);
    onder.add(Tstop);
    add(onder,BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent e) {
    JButton knop = (JButton)e.getSource();
    if (knop == Tstart) 
      p.start();
    else 
      p.stop();
    Tstart.setEnabled(!Tstart.isEnabled());
    Tstop.setEnabled(!Tstop.isEnabled());
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Timer");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new TimerVb());
        venster.pack();
        venster.setLocationRelativeTo(null);
        venster.setVisible(true);
    }});
  }
}