import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.util.*;
import java.text.*;

class Combo2 extends JPanel implements ActionListener{
  private JLabel res;
  private String patroon;
  private JComboBox combo;

  Combo2() {
    String[] lijst = { 
               "dd MMMMM yyyy",
               "dd.MM.yy", 
               "MM/dd/yy",
               "yyyy.MM.dd G 'at' hh:mm:ss z",
               "EEE, MMM d, ''yy",
               "h:mm a",
               "H:mm:ss:SSS",
               "K:mm a,z",
               "yyyy.MMMMM.dd GGG hh:mm aaa"
    };

    patroon = lijst[0];
 
    JLabel Label1a = new JLabel("Geef een patroon in of ");
    JLabel Label1b = new JLabel("selecteer een patroon uit de lijst: ");
    
    combo = new JComboBox(lijst);
    combo.setEditable(true);
    combo.addActionListener(this);     
        
    JLabel Label2 = new JLabel("Huidige Datum/Tijd");
    res = new JLabel(" ");
    res.setBorder(BorderFactory.createCompoundBorder(
                  BorderFactory.createLineBorder(Color.black),
                  BorderFactory.createEmptyBorder(5,5,5,5)
    ));
        
    JPanel boven = new JPanel();
    boven.setLayout(new BoxLayout(boven, BoxLayout.Y_AXIS));
    boven.add(Label1a);
    boven.add(Label1b);
    boven.add(combo);
    boven.setBorder(BorderFactory.createEmptyBorder(0,0,10,0));
    combo.setAlignmentX(Component.LEFT_ALIGNMENT);
        
    JPanel onder = new JPanel();
    onder.setLayout(new GridLayout(0, 1));
    onder.add(Label2);
    onder.add(res);
    
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    boven.setAlignmentX(Component.LEFT_ALIGNMENT);
    onder.setAlignmentX(Component.LEFT_ALIGNMENT);
    add(boven);
    add(onder);
    
    setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

    reformat();
  }

  public void actionPerformed(ActionEvent e) {
    patroon = (String)combo.getSelectedItem();
    reformat();
  }

  public void reformat() {
    Date today = new Date();
    try {
      SimpleDateFormat formatter = 
              new SimpleDateFormat(patroon);
      String dateString = formatter.format(today);
      res.setForeground(Color.black);
      res.setText(dateString);
    } catch (IllegalArgumentException iae) {
      res.setForeground(Color.red);
      res.setText("Error: " + iae.getMessage());
    }
  }

  public static void main(String s[]) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Voorbeeld 2 ComboBox");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new Combo2());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
