import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class Knoppen extends JPanel implements ActionListener{
  private JTextField tekstveld; 
 
  Knoppen() {
    JPanel knoppaneel = new JPanel();
            
    JButton knop1 = new JButton("ventje",new ImageIcon("tek.gif"));
    knop1.addActionListener(this);
    knoppaneel.add(knop1);

    JButton knop2 = new JButton("Tekst");
    knop2.setPreferredSize(new Dimension(100,100));
    knop2.setHorizontalAlignment(AbstractButton.LEFT);
    knop2.setVerticalAlignment(AbstractButton.BOTTOM);
    knop2.setMnemonic(KeyEvent.VK_T);
    knop2.addActionListener(this);   
    knoppaneel.add(knop2);

    JButton knop3 = new JButton("ventje",new ImageIcon("tek.gif"));
    knop3.setHorizontalTextPosition(AbstractButton.LEFT);
    knop3.setVerticalTextPosition(AbstractButton.TOP); 
    knop3.setActionCommand("knop3");
    knop3.addActionListener(this); 
    knoppaneel.add(knop3);    

    tekstveld = new JTextField();
    tekstveld.setEditable(false);

    setLayout(new BorderLayout());
    add(knoppaneel, BorderLayout.NORTH);
    add(tekstveld, BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("ventje")) 
      tekstveld.setText("Je hebt op de eerste knop geklikt");
    else if (e.getActionCommand().equals("Tekst")) 
      tekstveld.setText("Je hebt op de tweede knop geklikt");
    else if (e.getActionCommand().equals("knop3")) 
      tekstveld.setText("Je hebt op de derde knop geklikt");
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Enkele knoppen");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new Knoppen());
        venster.pack();
        venster.setLocationRelativeTo(null);
        venster.setVisible(true);
    }});
  }
}