import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class RadioButton extends JPanel implements ActionListener{
    
  private JLabel tekening;

  RadioButton() {
    JRadioButton hond = new JRadioButton("Hond",true);
    hond.setMnemonic(KeyEvent.VK_H);
    hond.addActionListener(this);

    JRadioButton kat = new JRadioButton("Kat");
    kat.setMnemonic(KeyEvent.VK_K);
    kat.addActionListener(this);
        
    JRadioButton varken = new JRadioButton("Varken");
    varken.setMnemonic(KeyEvent.VK_V);
    varken.addActionListener(this);

    ButtonGroup groep = new ButtonGroup();
    groep.add(hond);
    groep.add(kat);
    groep.add(varken);
        
    JPanel knoppenpaneel = new JPanel();
    knoppenpaneel.setLayout(new GridLayout(0,1,0,20));
    knoppenpaneel.add(hond);
    knoppenpaneel.add(kat);
    knoppenpaneel.add(varken);
    knoppenpaneel.setBorder(BorderFactory.createTitledBorder("Selecteer:"));

    tekening = new JLabel(new ImageIcon("HOND.gif"));
    tekening.setPreferredSize(new Dimension(160,160));

    setLayout(new GridLayout(1,0,20,0));
    add(knoppenpaneel);
    add(tekening);
  }

  public void actionPerformed(ActionEvent e) {
    tekening.setIcon(new ImageIcon(e.getActionCommand() + ".gif"));
  }
    
  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Voorbeeld Radiobuttons");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
        venster.setContentPane(new RadioButton());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
