import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.awt.*;

class Slider extends JPanel implements ChangeListener {
    
  private JSlider[] sliders;
  private JPanel kleur;
  private int r,g,b;

  Slider() {
    String labels[] = {" R:  "," G:  "," B:  "};  

    r=127; g=127; b=127;
    
    JPanel sliderpaneel = new JPanel();
    sliderpaneel.setLayout(new GridLayout(0,1,0,10));
    sliders = new JSlider[3];  

    for (int i=0; i<3; i++) {
      sliders[i] = new JSlider(0,255,r);
      sliders[i].setMajorTickSpacing(50);
      sliders[i].setMinorTickSpacing(10);
      sliders[i].setPaintTicks(true);
      sliders[i].setPaintLabels(true);
      sliders[i].addChangeListener (this);

      JPanel hulp = new JPanel();
      hulp.setLayout(new BoxLayout(hulp,BoxLayout.X_AXIS));
      JLabel temp = new JLabel(labels[i]);
      temp.setAlignmentY(Component.TOP_ALIGNMENT); 
      hulp.add(temp);
      sliders[i].setAlignmentY(Component.TOP_ALIGNMENT); 
      hulp.add(sliders[i]);
      sliderpaneel.add(hulp);
    }
	
    kleur = new JPanel();
    kleur.setPreferredSize(new Dimension(150,150));
    kleur.setBorder(BorderFactory.createLineBorder(new Color(0,0,0)));
    kleur.setBackground(new Color(r,g,b));

    setLayout(new BorderLayout(10,10));
    add(sliderpaneel,BorderLayout.WEST);
    add(kleur);
  }

  public void stateChanged (ChangeEvent e) {
    JSlider sl = (JSlider)e.getSource();
    if (sl==sliders[0]) r=sl.getValue();
    else if (sl==sliders[1]) g=sl.getValue();
    else if (sl==sliders[2]) b=sl.getValue();
    kleur.setBackground(new Color(r,g,b));
  }

  public static void main (String[] args){
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame ("Voorbeeld sliders");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane (new Slider());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
