//ActionDemo.java

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

class ActionDemo extends JFrame {

  private ActieStart aStart;
  private ActieStop aStop;
  private InhoudsPaneelVanActionDemo ip;

  ActionDemo(String titel) {
    super(titel);

    aStart = new ActieStart(this);
    aStop = new ActieStop(this);

    ip = new InhoudsPaneelVanActionDemo(aStart,aStop);
    setContentPane(ip);

    setJMenuBar(new MenuBalkVanActionDemo(aStart,aStop));

    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLocationRelativeTo(null);
    pack();
    setVisible(true);
  }

  void start() {
    ip.start();
    aStart.setEnabled(false);
    aStop.setEnabled(true);
  }

  void stop() {
    ip.stop();
    aStart.setEnabled(true);
    aStop.setEnabled(false);
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        new ActionDemo("ActionDemo");
    }}); 
  }
}