// BalPaneel.java 

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class BalPaneel extends JPanel
                       implements ActionListener {
  // gegevens over de positie van het balletje
  static final int STRAAL = 10; 
  static final int INTERVAL = 50; 

  private double vx; // horizontal snelheid
  private double vy; // verticale snelheid
  private double x;  // horizontale positie
  private double y;  // verticale positie
    
  private Timer timer; // geassocieerde timer

  BalPaneel(double vx, double vy) {
    this.vx = vx;
    this.vy = vy;
    x = STRAAL;
    y = STRAAL;
    timer = new Timer(INTERVAL, this);
  }

  long lasttime;

  public void actionPerformed(ActionEvent e) {
    long d = System.currentTimeMillis() - lasttime;
    lasttime += d;
    x += (int)(vx*d/INTERVAL);
    y += (int)(vy*d/INTERVAL);

    if (x < STRAAL) {
      x = STRAAL; vx = - vx;
    }
    else if (x + STRAAL > getWidth()) {
      x = getWidth() - STRAAL; vx = - vx;
    }
	
    if (y < STRAAL) {
      y = STRAAL; vy = - vy;
    }
    else if (y + STRAAL > getHeight()) {
      y = getHeight() - STRAAL; vy = - vy;
    }

    repaint();
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    g.setColor (Color.red);
    g.fillOval ((int)x - STRAAL, (int)y - STRAAL, 2*STRAAL, 2*STRAAL);
  }

  public void start() {
    timer.start();
    lasttime = System.currentTimeMillis();
  }
    
  public void stop() {
    timer.stop();
  }
}

