//ColorChooserDemo1.java

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class ColorChooserDemo1 extends JPanel implements ActionListener {
  private JPanel panel;

  ColorChooserDemo1() {
    JButton knop = new JButton("Kies kleur");
    knop.addActionListener(this);

    panel = new JPanel();
    panel.setPreferredSize(new Dimension(100,60));
    panel.setBackground(Color.red);
    
    setLayout(new BorderLayout());
    add(knop,BorderLayout.NORTH);
    add(panel);      
  }
  
  public void actionPerformed(ActionEvent e) {
    Color kleur = JColorChooser.showDialog(this,"Kies een kleur",panel.getBackground());
    if (kleur != null) 
      panel.setBackground(kleur);
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Kleuren");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new ColorChooserDemo1());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}