//ColorChooserDemo2.java

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;

class ColorChooserDemo2 extends JPanel implements ChangeListener {
  private JPanel panel;
  private JColorChooser cc;

  ColorChooserDemo2() {
    cc = new JColorChooser(Color.red);
    cc.getSelectionModel().addChangeListener(this);

    panel = new JPanel();
    panel.setPreferredSize(new Dimension(100,60));
    panel.setBackground(Color.red);
    
    setLayout(new BorderLayout());
    add(cc,BorderLayout.NORTH);
    add(panel);      
  }
  
  public void stateChanged (ChangeEvent e) {
    panel.setBackground(cc.getColor());
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Kleuren");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new ColorChooserDemo2());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}