//DialogDemo2.java

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class DialogDemo2 extends JFrame implements ActionListener {

  private FontDialog fd;
  private JLabel lbl; 

  DialogDemo2(String s) {
    super(s);

    lbl = new JLabel("Voorbeeld JDialog");
    lbl.setPreferredSize(new Dimension(250,100));
    lbl.setFont(new Font("Times new Roman",Font.BOLD,16));
    lbl.setHorizontalAlignment(JLabel.CENTER);            
    
    JButton btnFont = new JButton("Font...");
    btnFont.setMnemonic(KeyEvent.VK_F);
    btnFont.addActionListener(this);
    JButton btnEinde = new JButton("Einde");
    btnEinde.setMnemonic(KeyEvent.VK_E);
    btnEinde.addActionListener(this);

    JPanel knoppenpaneel = new JPanel(new GridLayout(1,0));
    knoppenpaneel.add(btnFont);
    knoppenpaneel.add(btnEinde);

    JPanel inhoudspaneel = new JPanel(new BorderLayout());
    inhoudspaneel.add(lbl);
    inhoudspaneel.add(knoppenpaneel,BorderLayout.SOUTH); 
    setContentPane(inhoudspaneel);

    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLocationRelativeTo(null);
    pack();
    setVisible(true);

    fd = new FontDialog(this);
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("Einde"))
      dispose();
    else     
      fd.setVisible(true);
  }

  public void wijzigFont(String font, Color kleur) {
    lbl.setFont(new Font(font,Font.BOLD,16));
    lbl.setForeground(kleur);    
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        new DialogDemo2("Voorbeeld JDialog");
    }});
  }
}