//FontDialog.java

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class FontDialog extends JDialog implements ActionListener {

  private DialogDemo2 ouder;
  private JRadioButton fontbegin, kleurbegin, fonthuidig, kleurhuidig;

  FontDialog(DialogDemo2 parent) {
    super(parent,"Font",false);
    ouder = parent;

    String[] strFont = {"Times New Roman", "Courier", "Wingdings"};
    ButtonGroup bgFont = new ButtonGroup();
    JPanel fontpaneel = new JPanel(new GridLayout(0,1));
    JRadioButton[] rbFont = new JRadioButton[3];
    for (int i=0; i<3; i++) {
      rbFont[i] = new JRadioButton(strFont[i],i==0);
      rbFont[i].addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
           fonthuidig = (JRadioButton)e.getSource();
      }});
      fontpaneel.add(rbFont[i]);
      bgFont.add(rbFont[i]);
    }
    fontpaneel.setBorder(BorderFactory.createTitledBorder("FontName"));
    fontbegin = rbFont[0];
    fonthuidig = fontbegin;

    String[] strColor = {"black", "red", "blue"};
    ButtonGroup bgColor = new ButtonGroup();
    JPanel kleurpaneel = new JPanel(new GridLayout(0,1));
    JRadioButton[] rbColor = new JRadioButton[3];
    for (int i=0; i<3; i++) {
      rbColor[i] = new JRadioButton(strColor[i],i==0);
      rbColor[i].addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          kleurhuidig = (JRadioButton)e.getSource();
      }});
      kleurpaneel.add(rbColor[i]);
      bgColor.add(rbColor[i]);
    }
    kleurpaneel.setBorder(BorderFactory.createTitledBorder("FontColor"));
    kleurbegin = rbColor[0];
    kleurhuidig = kleurbegin;

    JButton knApply = new JButton("Apply");
    knApply.setMnemonic(KeyEvent.VK_A);
    knApply.addActionListener(this);

    JButton knClose = new JButton("Close");
    knClose.setMnemonic(KeyEvent.VK_C);
    knClose.addActionListener(this);

    JPanel bovenpaneel = new JPanel(new GridLayout(1,0));
    bovenpaneel.add(fontpaneel);
    bovenpaneel.add(kleurpaneel);
    JPanel knoppenpaneel = new JPanel();
    knoppenpaneel.add(knApply);
    knoppenpaneel.add(knClose); 
    getContentPane().add(bovenpaneel);
    getContentPane().add(knoppenpaneel,BorderLayout.SOUTH);

    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    pack();
    setLocationRelativeTo(ouder);
  }
  
  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("Apply")) {
      Color kleur;
      if (kleurhuidig.getActionCommand().equals("black")) 
        kleur = Color.black;
      else if (kleurhuidig.getActionCommand().equals("red")) 
        kleur = Color.red;
      else
        kleur = Color.blue;
      kleurbegin = kleurhuidig;
      fontbegin = fonthuidig;
      ouder.wijzigFont(fonthuidig.getActionCommand(),kleur);   
    }
    else {
      setVisible(false);
      kleurbegin.setSelected(true);
      fontbegin.setSelected(true);
      kleurhuidig = kleurbegin;
      fonthuidig = fontbegin;
    }  
  }
}