//FileChooserDemo2.java

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

class FileChooserDemo2 extends JPanel implements ActionListener {
  private JLabel label;

  FileChooserDemo2() {
    JButton knop = new JButton("Klik hier");
    knop.addActionListener(this);
  
    label = new JLabel();
    label.setHorizontalAlignment(JLabel.CENTER);
    label.setVerticalAlignment(JLabel.CENTER);    
  
    setLayout(new BorderLayout());
    add(knop,BorderLayout.NORTH);
    add(label,BorderLayout.CENTER);
  }

   
  public void actionPerformed(ActionEvent e) {
    JFileChooser chooser = new JFileChooser(".");
    chooser.setFileFilter (new ExtFilter(".JPG"));  //[*]
    chooser.addChoosableFileFilter (new ExtFilter(".GIF"));  //[*]
    chooser.addChoosableFileFilter (new ExtFilter(".BMP"));  //[*]
    chooser.setAcceptAllFileFilterUsed(false);  //[*]
    int antw = chooser.showDialog(label,"Select");
    if (antw == JFileChooser.APPROVE_OPTION) {
        File file = chooser.getSelectedFile();
        label.setIcon(new ImageIcon(file.getPath()));
    }
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("FileChooserDemo");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new FileChooserDemo2());
        venster.setLocationRelativeTo(null);
        venster.setSize(200,200);
        venster.setVisible(true);
    }});
  }
}