//MenuBalkVanInternalFrameDemo

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class MenuBalkVanInternalFrameDemo extends JMenuBar implements ActionListener {
  private int nummer;
  private JDesktopPane desktop;

  MenuBalkVanInternalFrameDemo(JDesktopPane dt) {
    desktop = dt;
    nummer = 1;

    JMenu mnFile = new JMenu("File");
    mnFile.setMnemonic(KeyEvent.VK_F);
    add(mnFile);

    JMenuItem mnNew = new JMenuItem("New");
    mnNew.setMnemonic(KeyEvent.VK_N);
    mnNew.addActionListener(this);
    mnFile.add(mnNew);

    JMenuItem mnClose = new JMenuItem("Close");
    mnClose.setMnemonic(KeyEvent.VK_C);
    mnClose.addActionListener(this);
    mnFile.add(mnClose);

    JMenu mnOptions = new JMenu("Options");
    mnOptions.setMnemonic(KeyEvent.VK_0);
    add(mnOptions);

    JRadioButtonMenuItem mnLive = new JRadioButtonMenuItem("Live Dragmode",true);
    mnLive.setMnemonic(KeyEvent.VK_L);
    mnLive.addActionListener(new ActionListener() {
       public void actionPerformed(ActionEvent e) {
          desktop.setDragMode(JDesktopPane.LIVE_DRAG_MODE);
    }});
    mnOptions.add(mnLive);   

    JRadioButtonMenuItem mnOutline = new JRadioButtonMenuItem("Outline Dragmode");
    mnOutline.setMnemonic(KeyEvent.VK_O);
    mnOutline.addActionListener(new ActionListener() {
       public void actionPerformed(ActionEvent e) {
          desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
    }});
    mnOptions.add(mnOutline);

    ButtonGroup bg = new ButtonGroup();
    bg.add(mnLive);
    bg.add(mnOutline);   
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("Close")) {
       JInternalFrame frame = desktop.getSelectedFrame();
       if (frame != null) 
          frame.dispose();
    }
    else {  //New
       InternalFrame frame = new InternalFrame(nummer);
       nummer++;
       frame.setVisible(true);
       desktop.add(frame);
       try {
          frame.setSelected(true);
       } catch (java.beans.PropertyVetoException ex) {} 
    }
  }
}
