//MenuBalkVanMenuBalkDemo.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class MenuBalkVanMenuBalkDemo extends JMenuBar implements ActionListener, ItemListener {

  private MenuBalkDemo ouder;

  MenuBalkVanMenuBalkDemo(MenuBalkDemo ouder) {
    this.ouder = ouder;

    //Opbouw eerste menu
    JMenu menu1 = new JMenu("Menu1");
    menu1.setMnemonic(KeyEvent.VK_M);
    add(menu1);

    //3 gewone menuknoppen (JMenuItem)
    JMenuItem menuItem1 = new JMenuItem("A text-only menu item");
    menuItem1.setMnemonic(KeyEvent.VK_T); 
    menuItem1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1,
                                                    InputEvent.ALT_MASK));
    menuItem1.addActionListener(this);
    menu1.add(menuItem1);

    JMenuItem menuItem2 = new JMenuItem("Both text and icon", 
                          new ImageIcon("middle.gif"));
    menuItem2.setMnemonic(KeyEvent.VK_B);
    menuItem2.addActionListener(this);
    menu1.add(menuItem2);

    JMenuItem menuItem3 = new JMenuItem(new ImageIcon("middle.gif"));
    menuItem3.addActionListener(this);
    menu1.add(menuItem3);

    //2 radiobuttons
    menu1.addSeparator();
    ButtonGroup group = new ButtonGroup();
    JRadioButtonMenuItem rbMenuItem1 = 
               new JRadioButtonMenuItem("A radio button menu item",true);
    rbMenuItem1.setMnemonic(KeyEvent.VK_R);
    group.add(rbMenuItem1);
    rbMenuItem1.addActionListener(this);
    menu1.add(rbMenuItem1);
    JRadioButtonMenuItem rbMenuItem2 = new JRadioButtonMenuItem("Another one");
    rbMenuItem2.setMnemonic(KeyEvent.VK_O);
    group.add(rbMenuItem2);
    rbMenuItem2.addActionListener(this);
    menu1.add(rbMenuItem2);

    //2 checkboxen
    menu1.addSeparator();
    JCheckBoxMenuItem cbMenuItem1 = new JCheckBoxMenuItem("A check box menu item");
    cbMenuItem1.setMnemonic(KeyEvent.VK_C);
    cbMenuItem1.addItemListener(this);
    menu1.add(cbMenuItem1);

    JCheckBoxMenuItem cbMenuItem2 = new JCheckBoxMenuItem("Another one");
    cbMenuItem2.setMnemonic(KeyEvent.VK_H);
    cbMenuItem2.addItemListener(this);
    menu1.add(cbMenuItem2);

    //een submenu
    menu1.addSeparator();
    JMenu submenu = new JMenu("A submenu");
    submenu.setMnemonic(KeyEvent.VK_S);

    JMenuItem menuItem4 = new JMenuItem("An item in the submenu");
    menuItem4.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2,
                                                    InputEvent.ALT_MASK));
    menuItem4.addActionListener(this);
    submenu.add(menuItem4);

    JMenuItem menuItem5 = new JMenuItem("Another item");
    menuItem5.addActionListener(this);
    submenu.add(menuItem5);
    menu1.add(submenu);

    //opbouw tweede menu
    JMenu menu2 = new JMenu("Menu2");
    menu2.setMnemonic(KeyEvent.VK_E);
    add(menu2);
  }

  public void actionPerformed(ActionEvent e) {
    JMenuItem source = (JMenuItem)e.getSource();
    String s = "Action Event source: " + source.getText();
    ouder.voegToe(s + "\n");
  }

  public void itemStateChanged(ItemEvent e) {
    JMenuItem source = (JMenuItem)e.getSource();
    String s = "Item Event source: " + source.getText();
    ouder.voegToe(s + "\n");
  }
}