import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class OptionPaneDemo extends JPanel {
  static JFrame venster;
  private JButton knop2;

  OptionPaneDemo() {
    setLayout(new GridLayout(0,2));

    JButton knop1 = new JButton("showMessageDialog 1");
    knop1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(venster,"Dat was een kemel van een fout!", 
                                      "Foutboodschap", JOptionPane.ERROR_MESSAGE);

    }});
    add(knop1);

    knop2 = new JButton("showMessageDialog 2");
    knop2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(knop2,"Hier staat een eigen ikoon", 
                                      "Eigen ikoon", JOptionPane.ERROR_MESSAGE,
                                      new ImageIcon("Tek.gif"));
    }});
    add(knop2);

    JButton knop3 = new JButton("showConfirmDialog");
    knop3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int antw = JOptionPane.showConfirmDialog(null, 
                                 "Weet u zeker dat u wilt stoppen?",
                                 "Vraagje",JOptionPane.YES_NO_OPTION);
        if (antw == JOptionPane.YES_OPTION) 
          JOptionPane.showMessageDialog(venster,"Je hebt op Yes geklikt");
        else if (antw == JOptionPane.NO_OPTION) 
          JOptionPane.showMessageDialog(venster,"Je hebt op No geklikt");
        else 
          JOptionPane.showMessageDialog(venster,"Je hebt het venster gesloten");
    }});
    add(knop3);

    JButton knop4 = new JButton("showInputDialog 1");
    knop4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String antw = JOptionPane.showInputDialog(venster, "Vul uw naam in.",
                                  "Invullen aub", JOptionPane.INFORMATION_MESSAGE);
        if (antw == null) 
          JOptionPane.showMessageDialog(venster,"oei");
        else
          JOptionPane.showMessageDialog(venster,"Je hebt " + antw + " ingetikt");
    }});
    add(knop4);

    JButton knop5 = new JButton("showInputDialog 2");
    knop5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String[] kleuren = {"Rood","Geel","Groen","Blauw"};
        String antw = (String) JOptionPane.showInputDialog(venster, 
                                          "Selecteer een kleur.", "Kleur kiezen",  
                                          JOptionPane.INFORMATION_MESSAGE, null,
                                          kleuren, kleuren[1]);  
        JOptionPane.showMessageDialog(venster, antw + " werd geselecteerd");
    }});  
    add(knop5);

    JButton knop6 = new JButton("showInputDialog 3");
    knop6.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String antw = (String) JOptionPane.showInputDialog(venster, "Vul uw naam in.",
                                    "Invullen aub", JOptionPane.INFORMATION_MESSAGE,
                                     null, null, "Helga");
        if (antw == null) 
          JOptionPane.showMessageDialog(venster,"oei");
        else
          JOptionPane.showMessageDialog(venster,"Je hebt " + antw + " ingetikt");
    }});
    add(knop6);

    JButton knop7 = new JButton("showOptionDialog");
    knop7.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {       
        String[] kleuren = {"Rood","Geel","Groen","Blauw"};
        int antw = JOptionPane.showOptionDialog(venster, 
                                   "Kies een kleur.", "Kleur kiezen",  
                                   JOptionPane.DEFAULT_OPTION, 
                                   JOptionPane.INFORMATION_MESSAGE, null,
                                   kleuren, kleuren[1]);  
        if (antw < 0) 
          JOptionPane.showMessageDialog(venster,"oei");
        else
          JOptionPane.showMessageDialog(venster,"Je hebt op " + kleuren[antw] + " geklikt");
    }}); 
    add(knop7);
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        venster = new JFrame("Voorbeelden JOptionPane");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new OptionPaneDemo());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);  
    }});
  }
}