//ToolBarDemo.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ToolBarDemo extends JPanel implements ActionListener {
  private JTextArea output;
    
  ToolBarDemo() {
    //toolbar creeren
    JToolBar toolBar = new JToolBar();
    toolBar.setRollover(true);  
   
    JButton knop1 = new JButton(new ImageIcon("left.gif"));
    knop1.setToolTipText("Dit is de eerste knop");
    knop1.setActionCommand("Eerste knop\n");
    knop1.addActionListener(this); 
    toolBar.add(knop1);

    JButton knop2 = new JButton(new ImageIcon("middle.gif"));
    knop2.setToolTipText("Dit is de tweede knop");
    knop2.setActionCommand("Tweede knop\n");
    knop2.addActionListener(this); 
    toolBar.add(knop2);

    JButton knop3 = new JButton(new ImageIcon("right.gif"));
    knop3.setToolTipText("Dit is de derde knop");
    knop3.setActionCommand("Derde knop\n");
    knop3.addActionListener(this); 
    toolBar.add(knop3);

    //textarea creeren
    output = new JTextArea(5, 15);
    JScrollPane sp = new JScrollPane(output);

    //componenten toevoegen 
    setLayout(new BorderLayout());
    add(toolBar, BorderLayout.NORTH);
    add(sp, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent e) {
    output.append(e.getActionCommand());
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
       JFrame.setDefaultLookAndFeelDecorated(true);
       JDialog.setDefaultLookAndFeelDecorated(true);
       JFrame venster = new JFrame("ToolBarDemo");
       venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
       venster.setContentPane(new ToolBarDemo());
       venster.setLocationRelativeTo(null);
       venster.pack();
       venster.setVisible(true);
    }});
  }
}

