//WindowEventDemo.java;
//gebaseerd op WindowEventDemo uit de Java Tutorial

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class WindowEventDemo extends JFrame implements WindowListener,
                                         WindowFocusListener, WindowStateListener {
  private JTextArea output;

  WindowEventDemo(String titel) {
    super(titel);

    addWindowListener(this);
    addWindowFocusListener(this);
    addWindowStateListener(this);

    output = new JTextArea(15, 40);
    output.setEditable(false);
    JScrollPane scrollPane = new JScrollPane(output);

    getContentPane().add(scrollPane);
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLocationRelativeTo(null);
    pack();
    setVisible(true);

    checkStates();
  }

  private void checkStates() {
    Toolkit tk = getToolkit();
    if (!(tk.isFrameStateSupported(Frame.ICONIFIED))) 
      displaymessage("ICONIFIED wordt niet ondersteund");            
    if (!(tk.isFrameStateSupported(Frame.MAXIMIZED_VERT)))
      displaymessage("MAXIMIZED_VERT wordt niet ondersteund");
    if (!(tk.isFrameStateSupported(Frame.MAXIMIZED_HORIZ)))
      displaymessage("MAXIMIZED_HORIZ wordt niet ondersteund");
    if (!(tk.isFrameStateSupported(Frame.MAXIMIZED_BOTH)))
      displaymessage("MAXIMIZED_BOTH wordt niet ondersteund");
  }

  public void windowClosing(WindowEvent e) {
    displaymessage("WindowListener: windowClosing");
  }
  public void windowClosed(WindowEvent e) {
    displaymessage("WindowListener: windowClosed");
  }
  public void windowOpened(WindowEvent e) {
    displaymessage("WindowListener: windowOpened");
  }
  public void windowIconified(WindowEvent e) {
    displaymessage("WindowListener: windowIconified");
  }
  public void windowDeiconified(WindowEvent e) {
    displaymessage("WindowListener: windowDeiconified");
  }
  public void windowActivated(WindowEvent e) {
    displaymessage("WindowListener: windowActivated");
  }
  public void windowDeactivated(WindowEvent e) {
    displaymessage("WindowListener: windowDeactivated");
  }

  public void windowGainedFocus(WindowEvent e) {
    displaymessage("WindowFocusListener: windowGaindedFocus");
  } 
  public void windowLostFocus(WindowEvent e) {
    displaymessage("WindowFocusListener: windowLostFocus");
  } 

  public void windowStateChanged(WindowEvent e) {
    int oud = e.getOldState();
    int nieuw = e.getNewState();
    String msg = "WindowStateListener: windowStateChanged \n        oude toestand: " +
            state2string(oud) + "\n        nieuwe toestand: " + state2string(nieuw);
    displaymessage(msg); 
  }

  String state2string(int state) {
    //let op: (state & Frame.NORMAL) != 0 werkt niet!!
    if (state == Frame.NORMAL) 
      return "NORMAL";
    if ((state & Frame.ICONIFIED) != 0) 
      return "ICONIFIED";
    //MAXIMIZED_BOTH is a concatenation of two bits, so
    //we need to test for an exact match.
    if ((state & Frame.MAXIMIZED_BOTH) == Frame.MAXIMIZED_BOTH)
      return "MAXIMIZED_BOTH";
    if ((state & Frame.MAXIMIZED_VERT) != 0) 
      return "MAXIMIZED_VERT";
    if ((state & Frame.MAXIMIZED_HORIZ) != 0) 
      return "MAXIMIZED_HORIZ";
    return "UNKNOWN";
  }

  void displaymessage(String s) {
    output.append(s + "\n");
    System.out.println(s);
  }    

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
       JFrame.setDefaultLookAndFeelDecorated(true);
        new WindowEventDemo("WindowEventDemo");
    }});
  }
}
