//FormattedTextFieldDemo.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import javax.swing.text.MaskFormatter;
import java.text.NumberFormat;
import java.text.ParseException;

class FormattedTextFieldDemo extends JPanel implements PropertyChangeListener {
  private double bedrag, intrestvoet;
  private int periode; 

  private JFormattedTextField txtBedrag, txtIntrestvoet, txtPeriode, txtAflossing; 

  public FormattedTextFieldDemo() {
    bedrag = 10000;
    intrestvoet = 0;
    periode = 10;

    txtBedrag = new JFormattedTextField(NumberFormat.getCurrencyInstance());
    txtBedrag.setValue(new Double(bedrag));
    txtBedrag.addPropertyChangeListener("value", this);
 
    txtIntrestvoet = new JFormattedTextField(NumberFormat.getPercentInstance());
    txtIntrestvoet.setValue(intrestvoet);
    txtIntrestvoet.addPropertyChangeListener("value", this);

    MaskFormatter periodeformat = null;
    try {
      periodeformat = new MaskFormatter("##");
    } catch (ParseException exc) {}
    txtPeriode = new JFormattedTextField(periodeformat);
    txtPeriode.setValue("10");
    txtPeriode.addPropertyChangeListener("value", this);

    txtAflossing = new JFormattedTextField(NumberFormat.getCurrencyInstance());
    txtAflossing.setValue(new Double(berekenAflossing()));
    txtAflossing.setEditable(false);
    txtAflossing.setForeground(Color.red);

    setLayout(new GridLayout(0,2));
    add(new JLabel(" Te lenen bedrag: "));
    add(txtBedrag);
    add(new JLabel(" Intrestvoet: "));
    add(txtIntrestvoet);
    add(new JLabel(" Aantal jaar: "));
    add(txtPeriode);
    add(new JLabel(" Maandelijkse aflossing: "));
    add(txtAflossing);
  }

  public void propertyChange(PropertyChangeEvent e) {
    Object source = e.getSource();
    if (source == txtBedrag) 
       bedrag = ((Number)txtBedrag.getValue()).doubleValue();
    else if (source == txtIntrestvoet) 
       intrestvoet = ((Number)txtIntrestvoet.getValue()).doubleValue();
    else if (source == txtPeriode) 
       periode = Integer.parseInt((String)txtPeriode.getValue());
    double aflossing = berekenAflossing();
    txtAflossing.setValue(new Double(aflossing));
  }

  double berekenAflossing () {
    double I, partial1, denominator;
    if (intrestvoet != 0) {
      I = intrestvoet / 12.0;   
      partial1 = Math.pow((1 + I), (0.0 - periode*12));
      denominator = (1 - partial1) / I;
    } else { 
      denominator = periode*12;
    }
    return bedrag / denominator;
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("FormattedTextFieldDemo");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new FormattedTextFieldDemo());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}