//IPadres5.java: voorbeeld van een DocumentListener

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.text.*;
import javax.swing.event.*;

class IPadres5 extends JPanel implements ActionListener, DocumentListener {
  private JTextField[] tf;
  private JTextField txtvb;
  private JTextArea txtGebied;
    
  IPadres5() {
    tf = new JTextField[4];
    for (int i=0; i<4; i++) {
      tf[i] = new JTextField(3);
      tf[i].setDocument(new IPdigitDocument());  
      tf[i].setText("0");
      tf[i].getDocument().addDocumentListener(this);
    }

    txtvb = new JTextField("0.0.0.0",8);
    txtvb.setEditable(false);

    JButton knop = new JButton("Add");
    knop.addActionListener(this);
  
    txtGebied = new JTextArea(10,10);
    txtGebied.setEditable(false);

    JPanel ippaneel = new JPanel(new GridLayout(1,0));
    ippaneel.setBorder(BorderFactory.createTitledBorder("IP-adres"));
    ippaneel.add(tf[0]);ippaneel.add(new JLabel(" . "));
    ippaneel.add(tf[1]);ippaneel.add(new JLabel(" . ")); 
    ippaneel.add(tf[2]);ippaneel.add(new JLabel(" . "));
    ippaneel.add(tf[3]);

    JPanel hulp = new JPanel(new BorderLayout());
    hulp.add(ippaneel);
    hulp.add(txtvb,BorderLayout.SOUTH);

    JPanel knoppaneel = new JPanel(new BorderLayout());
    knoppaneel.add(knop);
    knoppaneel.setBorder(BorderFactory.createEmptyBorder(5,5,3,5));

    JPanel boven = new JPanel(new BorderLayout());
    boven.add(hulp);
    boven.add(knoppaneel,BorderLayout.EAST);
     
    setLayout(new BorderLayout());
    add(boven,BorderLayout.NORTH);
    add(new JScrollPane(txtGebied));
  }

  private String berekenIP() {
    String s = tf[0].getText();
    for (int i=1; i<4; i++) {
      s = s + "." + tf[i].getText();
    } 
    return s;
  }

  public void actionPerformed(ActionEvent e) {
    String s = berekenIP();
    s = s + "\n";
    txtGebied.append(s);
  }

  public void insertUpdate (DocumentEvent e) {
    String s = berekenIP();
    txtvb.setText(s);
  }

  public void removeUpdate (DocumentEvent e) {
    String s = berekenIP();
    txtvb.setText(s);
  }

  public void changedUpdate (DocumentEvent e) {}

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("IP-adres");
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setContentPane(new IPadres5());
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
