//InhoudsPaneelVanTextDemo.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.DefaultEditorKit;

public class InhoudsPaneelVanTextDemo extends JPanel implements ActionListener {
   private JTextField txtField;
   private JTextArea txtArea;
       
   InhoudsPaneelVanTextDemo() {
      txtField = new JTextField(20);
      txtField.addActionListener(this);
      addKeys(); 

      txtArea = new JTextArea(5, 20);
      txtArea.setEditable(false);

      JButton knop = new JButton("Wis tekstgebieden");  
      knop.addActionListener(this);  
   
      setLayout(new BorderLayout());
      add(txtField,BorderLayout.NORTH);
      add(new JScrollPane(txtArea),BorderLayout.CENTER);
      add(knop,BorderLayout.SOUTH);
    }

    public void actionPerformed(ActionEvent e) {
      if (e.getActionCommand().equals("Wis tekstgebieden")) { 
        txtArea.setText(""); 
        txtField.setText(""); 
        txtField.requestFocus(); 
      }
      else {  
        txtArea.append(txtField.getText() + "\n");
        txtArea.setCaretPosition(txtArea.getText().length());  
        txtField.selectAll(); 
      } 
    }

    protected void addKeys() {
       InputMap inputMap = txtField.getInputMap();

       //Enkel ter info: alle reeds bestaande keystrokes eens uitschrijven
       System.out.println("***********KeyStrokes:");
       KeyStroke[] keys = inputMap.allKeys();
       for (int i=0; i<keys.length; i++)
          System.out.println("" + keys[i]);
 
       KeyStroke key = KeyStroke.getKeyStroke(KeyEvent.VK_B, Event.CTRL_MASK);
       inputMap.put(key, DefaultEditorKit.backwardAction);
   
       key = KeyStroke.getKeyStroke(KeyEvent.VK_F, Event.CTRL_MASK);
       inputMap.put(key, DefaultEditorKit.forwardAction);

       key = KeyStroke.getKeyStroke(KeyEvent.VK_W,
                                          Event.CTRL_MASK);
       inputMap.put(key, DefaultEditorKit.beginWordAction);
    }

    public Action[] getActionsTextField() {
       return txtField.getActions();
    }
}