//ColorRenderer.java

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;

public class ColorRenderer extends JLabel implements TableCellRenderer {

  public Component getTableCellRendererComponent(JTable table, Object color,
                                                 boolean isSelected, boolean hasFocus,
                                                 int row, int column) {
    Color newColor = (Color)color;
    setBackground(newColor);
    if (isSelected)             
      setBorder(BorderFactory.createMatteBorder(2,5,2,5,
                         table.getSelectionBackground()));
    else            
      setBorder(BorderFactory.createMatteBorder(2,5,2,5,
                         table.getBackground()));
    setToolTipText("RGB value: " + newColor.getRed() + ", "+ newColor.getGreen() + ", "
                                 + newColor.getBlue());
    setOpaque(true);
    return this;
  }
}