// Lijsten1.java 
// vaste lijst, enkelvoudige selectie

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

class Lijsten1 extends JPanel implements ListSelectionListener {
  private JList lijst;
  private JTextField tekst;

  Lijsten1() { 
    String[] namen = { "Bach", "Beethoven", "Brahms", "Mozart", 
                       "Mendelssohn   ", "Schubert", "Schumann" };
    lijst = new JList(namen);
    lijst.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    lijst.setLayoutOrientation(JList.HORIZONTAL_WRAP);
    lijst.setVisibleRowCount(-1); //anders werkt vorige opdracht niet
    lijst.setPreferredSize(new Dimension(200,100));
    lijst.addListSelectionListener(this);     

    JScrollPane scroll = new JScrollPane(lijst); 

    tekst = new JTextField(" - onbekend componist - ");
    tekst.setEditable(false); 
      
    setLayout(new BorderLayout());
    add(scroll);
    add(tekst,BorderLayout.SOUTH);
  }

  public void valueChanged(ListSelectionEvent e) {
    if (lijst.isSelectionEmpty()) 
      tekst.setText (" - onbekend componist - ");
    else 
      tekst.setText((String) lijst.getSelectedValue());
  }

  public static void main (String[] arg) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame("Lijsten1");
        venster.setContentPane (new Lijsten1());    
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
