// Lijsten3.java 

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

class Lijsten3 extends JPanel implements ListSelectionListener {
  private JList lijst;
  private JTextArea tekst; 

  public static String[] namen = { "Bach", "Beethoven", "Brahms", "Mozart", 
                                   "Mendelssohn   ", "Schubert", "Schumann" };

  Lijsten3() {
    lijst = new JList(namen);
    lijst.setCellRenderer(new LijstenRenderer());
    lijst.addListSelectionListener(this);     

    tekst = new JTextArea (" - onbekend componist - "); 
    tekst.setEditable (false); 

    JScrollPane scroll1 = new JScrollPane(lijst); 
    JScrollPane scroll2 = new JScrollPane(tekst); 
      
    setLayout(new GridLayout(1,0));
    add(scroll1);
    add(scroll2);
  }

  public void valueChanged(ListSelectionEvent e) {
    if (lijst.isSelectionEmpty())
      tekst.setText(" - onbekend componist - ");
    else {
      String str = "";
      int[] indices = lijst.getSelectedIndices();
      for (int i=0; i < indices.length; i++) 
        str = str + namen[indices[i]] + "\n";
      tekst.setText(str);    
    }
  }

  public static void main (String[] arg) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
	JFrame venster = new JFrame("Lijsten3");
	venster.setContentPane(new Lijsten3());    
	venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setLocationRelativeTo(null);
	venster.pack();
	venster.setVisible(true);
    }});
  }
}
