// Lijsten4.java
// Veranderlijke lijst: gebruikt een 'DefaultListModel'

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class Lijsten4 extends JPanel implements ActionListener, ListSelectionListener {
    
  private JList lijst;
  private DefaultListModel model;
  private JButton toevoegKnop, verwijderKnop;
  private JTextField tekst;

  Lijsten4() {
    String[] namen = { "Bach", "Beethoven", "Brahms", "Mozart", 
                       "Mendelssohn", "Schubert", "Schumann" };
    model = new DefaultListModel();	
    for (int i=0; i < namen.length; i++)
      model.addElement(namen[i]);

    lijst = new JList(model);
    lijst.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    lijst.setSelectedIndex(0);
    lijst.addListSelectionListener(this);
    JScrollPane scroll = new JScrollPane(lijst);

    toevoegKnop = new JButton("Toevoegen");
    toevoegKnop.addActionListener(this);

    verwijderKnop = new JButton("Verwijderen");
    verwijderKnop.addActionListener(this);

    tekst = new JTextField(10);
    tekst.setText(namen[0]);

    JPanel knoppenPaneel = new JPanel();
    knoppenPaneel.add(tekst);
    knoppenPaneel.add(toevoegKnop);
    knoppenPaneel.add(verwijderKnop);

    setLayout(new BorderLayout());
    add(scroll, BorderLayout.CENTER);
    add(knoppenPaneel, BorderLayout.SOUTH);
  }    

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == verwijderKnop) {          
      int index = lijst.getSelectedIndex();
      model.remove(index);

      int size = model.getSize();
      if (size == 0) 
        verwijderKnop.setEnabled(false);
      else {
        if (index == model.getSize()) index--;
        lijst.setSelectedIndex(index);
      }
    }
    else {   
      String str = tekst.getText();
      if (str.length() == 0) return; // niets ingetikt

      int index = lijst.getSelectedIndex();
      int size = model.getSize();
      if (index == -1 || (index+1 == size)) {
        model.addElement(str);
        lijst.setSelectedIndex(size);
      } 
      else {
        model.insertElementAt(str, index+1);
        lijst.setSelectedIndex(index+1);
      }
    }
  }
  
  public void valueChanged(ListSelectionEvent e) {
    if (! e.getValueIsAdjusting()) {
      if (lijst.getSelectedIndex() == -1) {
        verwijderKnop.setEnabled(false);
        tekst.setText("");
      } else {
        verwijderKnop.setEnabled(true);
        tekst.setText((String)lijst.getSelectedValue());
      }
    }
  }

  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame venster = new JFrame ("Lijsten4");
        venster.setContentPane(new Lijsten4());
        venster.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        venster.setLocationRelativeTo(null);
        venster.pack();
        venster.setVisible(true);
    }});
  }
}
