//MyTableModel3.java

import javax.swing.table.*;
import java.awt.*;

public class MyTableModel3 extends AbstractTableModel {
  Object[][] data = {
    {"Mary", "red", new Integer(5), new Boolean(false)},
    {"Alison", "blue", new Integer(3), new Boolean(true)},
    {"Kathy", "yellow", new Integer(2), new Boolean(false)},
    {"Mark", "green", new Integer(20), new Boolean(true)},
    {"Angela", "pink", new Integer(4), new Boolean(false)}};

  String[] columnNames = {"Voornaam","Lievelingskleur",   
                          "Leeftijd","Vegetarisch"};       

  Class[] columnClasses = {String.class, String.class,            //[*]
                           Integer.class, Boolean.class};        //[*]                   

  public Object getValueAt(int row, int col) {                   
    return data[row][col];
  }

  public int getColumnCount() {
    return columnNames.length;                                  
  }

  public int getRowCount() {
    return data.length;
  }  

  public String getColumnName(int col) {                         
    return columnNames[col];                                    
  }  

  public Class getColumnClass(int col) {                         //[*]
    return columnClasses[col];                                  //[*]
  }
}
