import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;

public class MyTableModel5 extends AbstractTableModel {
  Object[][] data = {
     {"Mary", Color.red, new Integer(5), new Boolean(false)},
     {"Alison", Color.blue, new Integer(3), new Boolean(true)},
     {"Kathy", Color.yellow, new Integer(2), new Boolean(false)},
     {"Mark", Color.green, new Integer(20), new Boolean(true)},
     {"Angela", Color.pink, new Integer(4), new Boolean(false)}};

  String[] columnNames = {"Voornaam","Lievelingskleur","Leeftijd",    
                          "Vegetarisch"};  

  Class[] columnClasses = {String.class, Color.class, Integer.class,
                           Boolean.class};                      

  public Object getValueAt(int row, int col) {
    return data[row][col];
  }

  public int getColumnCount() {
    return columnNames.length;                                  
  }

  public int getRowCount() {
    return data.length;
  }  

  public String getColumnName(int col) {                         
    return columnNames[col];                                    
  }  

  public Class getColumnClass(int col) {
    return columnClasses[col];
  }

  public boolean isCellEditable(int row, int col) {           
    return col>=2;                                            
  }

  public void setValueAt(Object value, int row, int col) {     
    data[row][col] = value;
  }
}
