Public Class Form1
    Private lftChecked As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        btnHelp.CausesValidation = False
        lftChecked = False
        mtbLftd.RightToLeft = Windows.Forms.RightToLeft.Yes
        mtbLftd.Mask = "999"
    End Sub

    Private Sub btnHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHelp.Click
        MessageBox.Show("Alle velden moeten ingevuld worden!" & vbCrLf & _
          "naam = een string " & vbCrLf & _
          "leeftijd = een getal uit het interval [0,120]", "Help-info", MessageBoxButtons.OK)
    End Sub

    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        If lftChecked Then
            Me.Close()
        Else
            errprov.SetError(mtbLftd, "Gelieve ook je leeftijd in te vullen!")
            mtbLftd.Focus()
        End If
    End Sub

    Private Sub txtNaam_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtNaam.KeyPress
        If Asc(e.KeyChar) = 13 Then mtbLftd.Focus()
    End Sub

    Private Sub txtNaam_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtNaam.Validating
        If txtNaam.Text.Trim = "" Then
            e.Cancel = True
            errprov.SetError(txtNaam, "Gelieve je naam in te vullen!")
        Else
            errprov.SetError(txtNaam, "")
        End If
    End Sub

    Private Sub mtbLftd_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles mtbLftd.KeyPress
        If Asc(e.KeyChar) = 13 Then
            btnOK.Focus()
        End If
    End Sub

    Private Sub mtbLftd_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles mtbLftd.Validating
        Dim lft As Int32
        Try
            lft = Convert.ToInt32(mtbLftd.Text)
            If lft < 0 OrElse lft > 120 Then Throw New Exception
            errprov.SetError(mtbLftd, "")
        Catch ex As Exception
            e.Cancel = True
            errprov.SetError(mtbLftd, "Als leeftijd wordt een geheel getal" & vbCrLf & _
                    "uit het interval [0,120] verwacht!")
            mtbLftd.SelectAll()
        End Try
        lftChecked = True
    End Sub
End Class
