Public Class Form1
    Private lftChecked As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        btnHelp.CausesValidation = False
        lftChecked = False
        txtLftd.RightToLeft = Windows.Forms.RightToLeft.Yes
        txtLftd.MaxLength = 3
    End Sub

    Private Sub btnHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHelp.Click
        MessageBox.Show("Alle velden moeten ingevuld worden!" & vbCrLf & _
          "naam = een string " & vbCrLf & _
          "leeftijd = een getal uit het interval [0,120]", "Help-info", MessageBoxButtons.OK)
    End Sub

    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        If lftChecked Then
            Me.Close()
        Else
            MessageBox.Show("Gelieve ook je leeftijd in te vullen!", "fout", MessageBoxButtons.OK, MessageBoxIcon.Error)
            txtLftd.Focus()
        End If
    End Sub

    Private Sub txtNaam_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtNaam.Validating
        If txtNaam.Text.Trim = "" Then
            e.Cancel = True
            MessageBox.Show("Gelieve je naam in te vullen!", "Fout", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End If
    End Sub

    Private Sub txtLftd_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtLftd.Validating
        Dim lft As Int32
        Try
            lft = Convert.ToInt32(txtLftd.Text)
            If lft < 0 OrElse lft > 120 Then Throw New Exception
        Catch ex As Exception
            e.Cancel = True
            MessageBox.Show("Als leeftijd wordt een geheel getal" & vbCrLf & _
                    "uit het interval [0,120] verwacht!", "Fout", MessageBoxButtons.OK, MessageBoxIcon.Error)
            txtLftd.SelectAll()
        End Try
        lftChecked = True
    End Sub
End Class
