Public Class DragDropForm

    Private bron, doel As TextBox
    Private Sub Txt_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Txt1.MouseDown, Txt2.MouseDown
        bron = CType(sender, TextBox)
    End Sub

    Private Sub Txt_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Txt1.MouseMove, Txt2.MouseMove
        If e.Button <> Windows.Forms.MouseButtons.None Then
            If bron.Text <> "" Then
                bron.DoDragDrop(bron.Text, DragDropEffects.Copy Or DragDropEffects.Move)
            End If
        End If
    End Sub


    Private Sub txt_DragDrop(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles Txt2.DragDrop, Txt1.DragDrop
        If Not bron.Equals(doel) Then
            doel.Text = e.Data.GetData(DataFormats.Text).ToString
            If e.Effect = DragDropEffects.Move Then
                bron.Text = ""
            End If
            doel.Focus()
        End If
    End Sub

    Private Sub Txt_DragEnter(ByVal sender As Object, ByVal e As DragEventArgs) Handles Txt2.DragEnter, Txt1.DragEnter
        doel = CType(sender, TextBox)
        If Not bron.Equals(doel) Then

            'Check the format of the data being dropped.
            If e.Data.GetDataPresent(DataFormats.Text) Then
                'Checks if the CTRL key is held
                If CBool(e.KeyState And 8) Then
                    'Display the copy cursor.
                    e.Effect = e.AllowedEffect And DragDropEffects.Copy
                Else
                    'Display the move cursor
                    e.Effect = e.AllowedEffect And DragDropEffects.Move
                End If
            End If
        End If
    End Sub

    Private Sub DragDropForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Txt1.AllowDrop = True
        Txt2.AllowDrop = True
    End Sub

    Private Sub DragDropForm_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Txt1.Width = Me.ClientSize.Width - 10
        Txt2.Width = Txt1.Width
        Txt1.Height = (Me.ClientSize.Height - 15) \ 2
        Txt2.Height = Txt1.Height
        Txt1.Location = New Point(5, 5)
        Txt2.Location = New Point(5, Txt1.Height + 10)
    End Sub
End Class