/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDAttributeGroupTraverser
extends XSDAbstractTraverser {
    XSDAttributeGroupTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSAttributeGroupDecl traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        QName refAttr = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XSAttributeGroupDecl attrGrp = null;
        if (refAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"attributeGroup (local)", "ref"}, elmNode);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return null;
        }
        attrGrp = (XSAttributeGroupDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 2, refAttr, elmNode);
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null) {
            String childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                child = DOMUtil.getNextSiblingElement(child);
            }
            if (child != null) {
                Object[] args = new Object[]{refAttr};
                this.reportSchemaError("src-attribute_group", args, child);
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return attrGrp;
    }

    XSAttributeGroupDecl traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        String err;
        Element nextNode;
        String childName;
        XSAttributeGroupDecl attrGrp = new XSAttributeGroupDecl();
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (nameAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"attributeGroup (global)", "name"}, elmNode);
            nameAttr = "no name";
        }
        attrGrp.fName = nameAttr;
        attrGrp.fTargetNamespace = schemaDoc.fTargetNamespace;
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        if ((nextNode = this.traverseAttrsAndAttrGrps(child, attrGrp, schemaDoc, grammar, null)) != null) {
            Object[] args = new Object[]{nameAttr, DOMUtil.getLocalName(nextNode)};
            this.reportSchemaError("src-attribute_group", args, nextNode);
        }
        attrGrp.removeProhibitedAttrs();
        XSAttributeGroupDecl redefinedAttrGrp = (XSAttributeGroupDecl)this.fSchemaHandler.getGrpOrAttrGrpRedefinedByRestriction(2, new QName(XMLSymbols.EMPTY_STRING, nameAttr, nameAttr, schemaDoc.fTargetNamespace), schemaDoc, elmNode);
        if (redefinedAttrGrp != null && (err = attrGrp.validRestrictionOf(redefinedAttrGrp)) != null) {
            this.reportSchemaError("src-redefine.7.2.2", new Object[]{nameAttr, err}, child);
        }
        grammar.addGlobalAttributeGroupDecl(attrGrp);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return attrGrp;
    }
}

