/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.QName;

public class XSNamedMapImpl
implements XSNamedMap {
    String[] fNamespaces;
    int fNSNum;
    SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    QName fName = new QName();

    public XSNamedMapImpl(String namespace, SymbolHash map) {
        this.fNamespaces = new String[]{namespace};
        this.fMaps = new SymbolHash[]{map};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] namespaces, SymbolHash[] maps, int num) {
        this.fNamespaces = namespaces;
        this.fMaps = maps;
        this.fNSNum = num;
    }

    public XSNamedMapImpl(XSObject[] array, int length) {
        if (length == 0) {
            this.fNSNum = 0;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{array[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = array;
        this.fLength = length;
    }

    public synchronized int getMapLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            int i = 0;
            while (i < this.fNSNum) {
                this.fLength += this.fMaps[i].getLength();
                ++i;
            }
        }
        return this.fLength;
    }

    public XSObject getNSItem(String namespace, String localName) {
        if (namespace != null) {
            namespace = namespace.intern();
        }
        int i = 0;
        while (i < this.fNSNum) {
            if (namespace == this.fNamespaces[i]) {
                if (this.fMaps != null) {
                    return (XSObject)this.fMaps[i].get(localName);
                }
                int j = 0;
                while (j < this.fLength) {
                    XSObject ret = this.fArray[j];
                    if (ret.getName().equals(localName)) {
                        return ret;
                    }
                    ++j;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public synchronized XSObject getItem(int index) {
        if (this.fArray == null) {
            this.getMapLength();
            this.fArray = new XSObject[this.fLength];
            int pos = 0;
            int i = 0;
            while (i < this.fNSNum) {
                pos += this.fMaps[i].getValues(this.fArray, pos);
                ++i;
            }
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }
}

