/*
 * Decompiled with CFR 0.152.
 */
class BSpline
implements Algoritme {
    private GraphicData data;
    private boolean initialized;

    public BSpline(GraphicData data) {
        this.setData(data);
        this.initialized = true;
    }

    private Point[] boor(double startt, double endt, double step) {
        int aantal = Math.abs((int)((endt - startt) / step + 1.0));
        Point[] results = new Point[aantal];
        int kc = 0;
        for (double t = startt; t < endt && kc < aantal; t += step, ++kc) {
            results[kc] = this.calcPoint(t);
        }
        while (kc < aantal) {
            results[kc] = this.calcPoint(endt);
            ++kc;
        }
        return results;
    }

    public Point calcPoint(double t) {
        int k = this.data.getOrder();
        return this.calcTriangle(t, k)[k - 1][0];
    }

    private Point[][] calcTriangle(double[] t) {
        int i;
        int b;
        int depth = t.length;
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        for (b = k; b < n - k && nodes[b].getT() < t[0]; ++b) {
        }
        b -= k;
        Point[][] P = new Point[depth + 1][k];
        for (i = 0; i < k; ++i) {
            P[0][i] = this.data.getPoint(b + i);
        }
        for (i = 1; i <= depth; ++i) {
            for (int j = 0; j < k - i; ++j) {
                double noemer = nodes[b + j + k].getT() - nodes[b + i + j].getT();
                double left = (nodes[b + j + k].getT() - t[i - 1]) / noemer;
                double x = P[i - 1][j].getX() * left + P[i - 1][j + 1].getX() * (1.0 - left);
                double y = P[i - 1][j].getY() * left + P[i - 1][j + 1].getY() * (1.0 - left);
                P[i][j] = new Point(x, y);
            }
        }
        return P;
    }

    private Point[][] calcTriangle(double t, int depth) {
        double[] a = new double[depth];
        for (int i = 0; i < depth; ++i) {
            a[i] = t;
        }
        return this.calcTriangle(a);
    }

    private double[] calcGraph(double[] tab, double t, int k) {
        int len = tab.length;
        Node[] nodes = this.data.getNodes();
        double[] nTab = new double[len - 1];
        for (int i = 0; i < len; ++i) {
            double noemer = nodes[i + k - 1].getT() - nodes[i].getT();
            if (noemer == 0.0) continue;
            double left = (t - nodes[i].getT()) / noemer;
            if (i < len - 1) {
                nTab[i] = tab[i] * left;
            }
            if (i <= 0) continue;
            int n = i - 1;
            nTab[n] = nTab[n] + tab[i] * (1.0 - left);
        }
        return nTab;
    }

    public Point[] calcBezierSegment(double a, double b) {
        int i;
        int k = this.data.getOrder();
        double[][] c = new double[k][k - 1];
        Point[] p = new Point[k - 1];
        for (i = 0; i < k - 1; ++i) {
            int n = 0;
            int j = 0;
            while (j < k - 1 - i) {
                c[i][n] = a;
                ++j;
                ++n;
            }
            j = 0;
            while (j < i) {
                c[i][n] = b;
                ++j;
                ++n;
            }
        }
        for (i = 0; i < k - 1; ++i) {
            p[i] = this.calcPoint(c[i]);
        }
        return p;
    }

    public Point[] calcBezier() {
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        int start = k - 1;
        int end = n - k;
        int len = (end - start) * (k - 1) + 1;
        Point[] p = new Point[len];
        int m = 0;
        for (int i = start; i < end; ++i) {
            Point[] segment = this.calcBezierSegment(nodes[i].getT(), nodes[i + 1].getT());
            int j = 0;
            while (j < segment.length) {
                p[m] = segment[j];
                ++j;
                ++m;
            }
        }
        p[m] = this.calcPoint(nodes[end].getT());
        return p;
    }

    public void setData(GraphicData data) {
        this.data = data;
        if (!this.isValidData(data)) {
            int n = data.getPointsCount();
            int k = data.getOrder();
            data.cleanNodes();
            data.addNode(new Node(0.0));
            data.addNode(new Node(1.0));
            for (int i = 0; i < n + k - 2; ++i) {
                data.addNewNodeAndDistributeUniform();
            }
        }
        this.initialized = true;
    }

    public boolean isValidData(GraphicData data) {
        int n = data.getPointsCount();
        int k = data.getOrder();
        if (k <= 0) {
            return false;
        }
        return data.getNodesCount() == n + k;
    }

    public GraphicData getData() throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        return this.data;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void reset() throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        this.data = null;
        this.initialized = false;
    }

    public Point[] calculateCurve() throws NotInitializedException {
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        double tStart = nodes[k - 1].getT();
        double tEnd = nodes[n - k].getT();
        return this.calculateCurve(tStart, tEnd);
    }

    public int[] calculateCurveX() throws NotInitializedException {
        return this.calculateCurveX(100.0);
    }

    public int[] calculateCurveY() throws NotInitializedException {
        return this.calculateCurveY(100.0);
    }

    public int[] calculateCurveX(double precision) throws NotInitializedException {
        double d = 1.0 / ((double)(this.data.getPointsCount() - 1) * precision);
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        double tStart = nodes[k - 1].getT();
        double tEnd = nodes[n - k].getT();
        return this.calculateCurveX(tStart, tEnd, d);
    }

    public int[] calculateCurveY(double precision) throws NotInitializedException {
        double d = 1.0 / ((double)(this.data.getPointsCount() - 1) * precision);
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        double tStart = nodes[k - 1].getT();
        double tEnd = nodes[n - k].getT();
        return this.calculateCurveY(tStart, tEnd, d);
    }

    public Point[] calculateCurve(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurve(start, end, d);
    }

    public int[] calculateCurveX(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurveX(start, end, d);
    }

    public int[] calculateCurveY(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurveY(start, end, d);
    }

    public Point[] calculateCurve(double start, double end, double precision) throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        return this.boor(start, end, precision);
    }

    public int[] calculateCurveX(double start, double end, double precision) throws NotInitializedException {
        Point[] points = this.calculateCurve(start, end, precision);
        if (points == null) {
            return null;
        }
        return Point.getXarray(points);
    }

    public int[] calculateCurveY(double start, double end, double precision) throws NotInitializedException {
        Point[] points = this.calculateCurve(start, end, precision);
        if (points == null) {
            return null;
        }
        return Point.getYarray(points);
    }

    public void addPoint(Point p) {
        this.data.addPoint(p);
        this.data.addNewNodeAndDistributeUniform();
    }

    public double getT(Point p) {
        double t;
        int k = this.data.getOrder();
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        double tStart = nodes[k - 1].getT();
        double tEnd = nodes[n - k].getT();
        double step = 1.0 / (double)((this.data.getPointsCount() - 1) * 1000);
        Point[] points = this.boor(tStart, tEnd, step);
        double minD = p.getDistance(points[0]);
        double minT = t = tStart;
        int i = 1;
        while (i < points.length) {
            double d = p.getDistance(points[i]);
            if (d < minD) {
                minD = d;
                minT = t;
            }
            ++i;
            t += step;
        }
        return minT;
    }

    public double[] calcGraph(double t) {
        int i;
        Node[] nodes = this.data.getNodes();
        int n = nodes.length - 1;
        int m = this.data.getPointsCount();
        int k = this.data.getOrder();
        double[] tab = new double[n];
        for (i = 0; i < n; ++i) {
            tab[i] = t >= nodes[i].getT() && t < nodes[i + 1].getT() ? 1.0 : 0.0;
        }
        i = 0;
        while (tab.length > m) {
            tab = this.calcGraph(tab, t, i + 2);
            ++i;
        }
        return tab;
    }

    public double[][] calcGraphs(double startt, double endt, double step) {
        int n = this.data.getPointsCount();
        int aantal = (int)((endt - startt) / step + 1.0);
        double[][] res = new double[n][aantal];
        double t = startt;
        for (int k = 0; k < aantal; ++k) {
            double[] graphs = this.calcGraph(t);
            for (int j = 0; j < graphs.length; ++j) {
                res[j][k] = graphs[j];
            }
            t += step;
        }
        return res;
    }

    public Point[][] tempConstruct(double t) {
        int k = this.data.getOrder();
        Point[][] p = this.calcTriangle(t, k);
        Point[][] temp = new Point[k][k];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                temp[i][j] = p[i][j];
            }
        }
        return temp;
    }

    public void addNode(double t) {
        int k = this.data.getOrder();
        Point[][] P = this.calcTriangle(t, 2);
        for (int i = 1; i < k - 1; ++i) {
            P[0][i].set(P[1][i - 1]);
        }
        this.data.insertPoint(this.data.getPointIndex(P[0][k - 1]), P[1][k - 2]);
        this.data.addNode(new Node(t));
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        double t = node.getT();
        int index = -1;
        double minD = 1.0;
        Point[] points = this.data.getPoints();
        for (int i = 0; i < points.length; ++i) {
            double t2 = this.getT(points[i]);
            double d = Math.abs(t - t2);
            if (!(d < minD)) continue;
            minD = d;
            index = i;
        }
        if (index == -1) {
            return;
        }
        this.data.removeNode(node);
        this.data.removePoint(index);
    }

    public void halveer() {
        Node[] nodes = this.data.getNodes();
        int k = this.data.getOrder();
        int n = nodes.length;
        int start = k - 1;
        int end = n - k;
        double t0 = nodes[start].getT();
        for (int i = start + 1; i <= end; ++i) {
            double t1 = nodes[i].getT();
            this.addNode((t0 + t1) / 2.0);
            t0 = t1;
        }
    }

    public void verdeelUniform() {
        this.data.distributeUniform();
    }

    public void verdeelOpenUniform() {
        this.data.distributeOpenUniform();
    }

    public boolean isValidNodeMove(Node node, double t, double e) {
        int i;
        int k;
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        for (k = 0; k < n && nodes[k] != node; ++k) {
        }
        if (k == n) {
            return false;
        }
        for (i = 0; i < k; ++i) {
            if (!(nodes[i].getT() > t)) continue;
            return false;
        }
        for (i = n - 1; i > k; --i) {
            if (!(nodes[i].getT() < t)) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveNode(double t) {
        int k = this.data.getOrder();
        int nVirtual = 2 * k - 4;
        int n = this.data.getNodesCount();
        if (n <= nVirtual + 2) {
            return false;
        }
        Node[] nodes = this.data.getNodes();
        double tStart = nodes[k - 2].getT();
        double tEnd = nodes[n - k + 1].getT();
        return !(t < tStart) && !(t > tEnd);
    }

    public void increaseOrder() {
        int i;
        Node[] nodes = this.data.getNodes();
        int k = this.data.getOrder();
        int n = nodes.length;
        int start = k - 1;
        int end = n - k;
        int nLen = n + (end - start + 1);
        Node[] nNodes = new Node[nLen];
        int i2 = 0;
        int j = 0;
        while (i2 < n) {
            if (i2 < start || i2 > end) {
                nNodes[j] = nodes[i2];
            }
            if (i2 >= start && i2 <= end) {
                nNodes[j] = nodes[i2];
                nNodes[j + 1] = nodes[i2];
                ++j;
            }
            ++i2;
            ++j;
        }
        Point[] nPoints = new Point[nLen - k - 1];
        for (i = 1; i < nLen - k; ++i) {
            double x = 0.0;
            double y = 0.0;
            for (int j2 = 0; j2 < k; ++j2) {
                double[] t = new double[k - 1];
                int m = 0;
                for (int l = 0; l < k; ++l) {
                    if (l == j2) continue;
                    t[m++] = nNodes[i + l].getT();
                }
                Point p = this.calcPoint(t);
                x += p.getX();
                y += p.getY();
            }
            nPoints[i - 1] = new Point(x / (double)k, y / (double)k);
        }
        this.data.reset();
        this.data.setOrder(k + 1);
        for (i = 0; i < nPoints.length; ++i) {
            this.data.addPoint(nPoints[i]);
        }
        for (i = 0; i < nNodes.length; ++i) {
            this.data.addNode(nNodes[i]);
        }
    }

    private Point calcPoint(double[] t) {
        int k = this.data.getOrder();
        return this.calcTriangle(t)[k - 1][0];
    }
}

