/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class Data
implements Cloneable,
GraphicData,
Zoomable,
Rotatable {
    private LinkedList points;
    private LinkedList nodes;
    private double totalZoomX;
    private double totalZoomY;
    private double zoomX;
    private double zoomY;
    private Point zoomCenter;
    protected EventListenerList listenerListPoints;
    protected EventListenerList listenerListNodes;
    protected EventListenerList listenerList;
    protected final ChangeEvent changeEvent = new ChangeEvent(this);
    private int order = 0;

    public Data() {
        this.reset();
    }

    public Object clone() {
        Data d = new Data();
        LinkedList<Object> p = new LinkedList<Object>();
        ListIterator it = this.points.listIterator();
        while (it.hasNext()) {
            p.add(((Point)it.next()).clone());
        }
        LinkedList<Object> l = new LinkedList<Object>();
        ListIterator it2 = this.nodes.listIterator();
        while (it2.hasNext()) {
            l.add(((Node)it2.next()).clone());
        }
        d.points = p;
        d.nodes = l;
        d.order = this.order;
        d.totalZoomX = this.totalZoomX;
        d.totalZoomY = this.totalZoomY;
        d.zoomX = this.zoomX;
        if (this.zoomCenter != null) {
            d.zoomCenter = (Point)this.zoomCenter.clone();
        }
        return d;
    }

    public void reset() {
        this.points = new LinkedList();
        this.nodes = new LinkedList();
        this.resetZoom();
        this.resetListeners();
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public void insertPoint(int index, Point point) throws IndexOutOfBoundsException {
        this.points.add(index, point);
    }

    public void setPoint(int index, Point point) throws IndexOutOfBoundsException {
        this.points.set(index, point);
        this.fireStateChangedPoints();
    }

    public Point getPoint(int index) throws IndexOutOfBoundsException {
        return (Point)this.points.get(index);
    }

    public int getPointIndex(Point point) {
        return this.points.indexOf(point);
    }

    public int getPoint(int x, int y) {
        return this.getPoint(x, y, 0.0);
    }

    public int getPoint(int x, int y, double radius) {
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = (Point)this.points.get(i);
            if (!(Math.abs(p.getX() - (double)x) <= radius) || !(Math.abs(p.getY() - (double)y) <= radius)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPoint(int x, int y) {
        return this.isPoint(x, y, 0.0);
    }

    public boolean isPoint(int x, int y, double radius) {
        return this.getPoint(x, y, radius) != -1;
    }

    public boolean removePoint(Point point) {
        boolean b = this.points.remove(point);
        this.fireStateChangedPoints();
        return b;
    }

    public void removePoint(int index) throws IndexOutOfBoundsException {
        this.points.remove(index);
        this.fireStateChangedPoints();
    }

    public Point[] getPoints() {
        Point[] array = new Point[this.getPointsCount()];
        this.points.toArray(array);
        return array;
    }

    public int getPointsCount() {
        return this.points.size();
    }

    public Node addNewNodeAndDistributeUniform() {
        double d;
        int n = this.getNodesCount();
        double val = d = 1.0 / (double)n;
        Node[] nTab = this.getNodes();
        int i = 1;
        while (i < n - 1) {
            nTab[i].setT(val);
            ++i;
            val += d;
        }
        Node node = new Node(1.0 - d);
        this.addNode(node);
        this.fireStateChangedNodes();
        return node;
    }

    public void addNode(Node node) {
        int k;
        double t = node.getT();
        if (this.nodes.size() == 0) {
            this.nodes.add(node);
            this.fireStateChangedNodes();
            return;
        }
        double t0 = ((Node)this.nodes.get(0)).getT();
        for (k = 1; k < this.nodes.size() && t > t0; ++k) {
            t0 = ((Node)this.nodes.get(k)).getT();
        }
        if (t <= t0) {
            --k;
        }
        this.nodes.add(k, node);
        this.fireStateChangedNodes();
    }

    public Node getNode(double value) {
        return this.getNode(value, 0.0);
    }

    public Node getNode(double value, double e) {
        ListIterator it = this.nodes.listIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!(Math.abs(node.getT() - value) <= e)) continue;
            return node;
        }
        return null;
    }

    public Node[] getNodes(double value) {
        return this.getNodes(value, 0.0);
    }

    public Node[] getNodes(double value, double e) {
        LinkedList<Node> lst = new LinkedList<Node>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = (Node)this.nodes.get(i);
            if (!(Math.abs(node.getT() - value) <= e)) continue;
            lst.add(node);
        }
        Node[] array = new Node[lst.size()];
        lst.toArray(array);
        return array;
    }

    public boolean isNode(double value) {
        return this.isNode(value, 0.0);
    }

    public boolean isNode(double value, double e) {
        return this.getNode(value, e) != null;
    }

    public int countNodes(double value) {
        return this.countNodes(value, 0.0);
    }

    public int countNodes(double value, double e) {
        return this.getNodes(value, e).length;
    }

    public boolean removeNode(Node node) {
        boolean b = this.nodes.remove(node);
        this.fireStateChangedNodes();
        return b;
    }

    public Node moveNode(Node node, double value) {
        node.setT(value);
        int i = this.nodes.indexOf(node);
        if (i > 0 && i < this.nodes.size() - 1) {
            Node prev = (Node)this.nodes.get(i - 1);
            Node next = (Node)this.nodes.get(i + 1);
            if (prev.getT() > node.getT()) {
                Node h = prev;
                prev = node;
                node = h;
            } else if (next.getT() < node.getT()) {
                Node h = next;
                next = node;
                node = h;
            }
        }
        this.fireStateChangedNodes();
        return node;
    }

    public Node[] getNodes() {
        Node[] array = new Node[this.getNodesCount()];
        this.nodes.toArray(array);
        return array;
    }

    public int getNodesCount() {
        return this.nodes.size();
    }

    public void distributeUniform() {
        double t = 0.0;
        double step = 1.0 / (double)(this.nodes.size() - 1);
        Node[] n = this.getNodes();
        int i = 0;
        while (i < this.nodes.size() - 1) {
            n[i].setT(t);
            ++i;
            t += step;
        }
        this.fireStateChangedNodes();
    }

    public void distributeOpenUniform() {
        int i;
        Node[] nodes = this.getNodes();
        int n = this.getNodesCount();
        int start = this.order - 1;
        int end = n - this.order;
        double step = 1.0 / (double)(end - start);
        for (i = 0; i < start; ++i) {
            nodes[i].setT(0.0);
        }
        for (i = start; i <= end; ++i) {
            nodes[i].setT((double)(i - start) * step);
        }
        for (i = end + 1; i < n; ++i) {
            nodes[i].setT(1.0);
        }
        this.fireStateChangedNodes();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void save(File file) throws IOException {
        FileWriter fw = new FileWriter(file, false);
        fw.write("GTP 2003\r\n");
        if (this.zoomCenter != null) {
            fw.write("ZOOM_CENTER," + this.zoomCenter.getX() + "," + this.zoomCenter.getY() + "\r\n");
            fw.write("ZOOM_X," + this.totalZoomX + "\r\n");
            fw.write("ZOOM_Y," + this.totalZoomY + "\r\n");
        }
        fw.write("O," + this.order + "\r\n");
        ListIterator it = this.nodes.listIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            fw.write("N," + node.getT() + "\r\n");
        }
        it = this.points.listIterator();
        while (it.hasNext()) {
            Point point = (Point)it.next();
            fw.write("P," + point.getX() + "," + point.getY() + "\r\n");
        }
        fw.close();
    }

    public void load(File file) throws IOException {
        this.reset();
        FileReader fr = new FileReader(file);
        char[] in = new char[8];
        int status = fr.read(in, 0, 8);
        StringBuffer sb = new StringBuffer();
        sb.append(in);
        if (!sb.toString().equals("GTP 2003")) {
            fr.close();
            throw new IOException(file + " (ongeldige bestandsindeling)");
        }
        while (status != -1) {
            in = new char[8];
            status = fr.read(in, 0, 8);
            sb.append(in);
        }
        fr.close();
        StringTokenizer tk = new StringTokenizer(sb.toString());
        while (tk.hasMoreTokens()) {
            String code;
            String token = tk.nextToken();
            StringTokenizer line = new StringTokenizer(token, ",");
            int n = line.countTokens();
            if (n == 2) {
                code = line.nextToken();
                if (code.equals("N")) {
                    try {
                        double t = Double.parseDouble(line.nextToken());
                        Node node = new Node(t);
                        this.addNode(node);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (code.equals("ZOOM_X")) {
                    try {
                        this.totalZoomX = Integer.parseInt(line.nextToken());
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (code.equals("ZOOM_Y")) {
                    try {
                        this.totalZoomY = Integer.parseInt(line.nextToken());
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (!code.equals("O")) continue;
                try {
                    this.order = Integer.parseInt(line.nextToken());
                }
                catch (Exception ex) {}
                continue;
            }
            if (n != 3) continue;
            code = line.nextToken();
            if (code.equals("P")) {
                try {
                    double x = Double.parseDouble(line.nextToken());
                    double y = Double.parseDouble(line.nextToken());
                    Point p = new Point(x, y);
                    this.points.add(p);
                }
                catch (Exception ex) {}
                continue;
            }
            if (!code.equals("ZOOM_CENTER")) continue;
            try {
                double x = Double.parseDouble(line.nextToken());
                double y = Double.parseDouble(line.nextToken());
                this.zoomCenter = new Point(x, y);
            }
            catch (Exception ex) {}
        }
    }

    public void resetZoom() {
        this.totalZoomX = 1.0;
        this.totalZoomY = 1.0;
        this.zoomX = 1.0;
        this.zoomY = 1.0;
        this.zoomCenter = null;
    }

    public double getZoomX() {
        return this.totalZoomX;
    }

    public double getZoomY() {
        return this.totalZoomY;
    }

    public Point getZoomCenter() {
        return this.zoomCenter;
    }

    public void zoomX(Point center, double factor) {
        this.zoom(center, factor, 1.0);
    }

    public void zoomY(Point center, double factor) {
        this.zoom(center, 1.0, factor);
    }

    public void zoom(Point center, double factor) {
        this.zoom(center, factor, factor);
    }

    public void zoom(Point center, double factorX, double factorY) {
        this.zoomCenter = center;
        this.zoomX = factorX;
        this.zoomY = factorY;
        this.performZoom();
    }

    private void performZoom() {
        this.totalZoomX *= this.zoomX;
        this.totalZoomY *= this.zoomY;
        Point[] p = this.getPoints();
        for (int i = 0; i < p.length; ++i) {
            this.zoomPoint(p[i]);
        }
        this.fireStateChanged();
    }

    private void zoomPoint(Point point) {
        if (this.zoomCenter == null) {
            return;
        }
        double centerX = this.zoomCenter.getX();
        double centerY = this.zoomCenter.getY();
        double newX = centerX + this.zoomX * (point.getX() - centerX);
        double newY = centerY + this.zoomY * (point.getY() - centerY);
        point.set(newX, newY);
    }

    public void restoreOrginalScaleX() {
        this.zoomX = 1.0 / this.totalZoomX;
        this.performZoom();
    }

    public void restoreOrginalScaleY() {
        this.zoomY = 1.0 / this.totalZoomY;
        this.performZoom();
    }

    public void restoreOriginalScale() {
        this.zoomX = 1.0 / this.totalZoomX;
        this.zoomY = 1.0 / this.totalZoomY;
        this.performZoom();
    }

    public void translate(double dx, double dy) {
        Point[] p = this.getPoints();
        for (int i = 0; i < p.length; ++i) {
            p[i].set(p[i].getX() + dx, p[i].getY() + dy);
        }
        this.fireStateChanged();
    }

    public void resetListeners() {
        this.listenerList = new EventListenerList();
        this.listenerListNodes = new EventListenerList();
        this.listenerListPoints = new EventListenerList();
    }

    public void copyListeners(Data data) {
        data.listenerList = this.listenerList;
        data.listenerListNodes = this.listenerListNodes;
        data.listenerListPoints = this.listenerListPoints;
        this.update();
    }

    public void update() {
        this.fireStateChanged();
    }

    public void addPointChangeListener(ChangeListener l) {
        this.listenerListPoints.add(ChangeListener.class, l);
    }

    public void removePointChangeListener(ChangeListener l) {
        this.listenerListPoints.remove(ChangeListener.class, l);
    }

    protected void fireStateChangedPoints() {
        Object[] listeners = this.listenerListPoints.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
        this.fireStateChanged();
    }

    public void addNodeChangeListener(ChangeListener l) {
        this.listenerListNodes.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this.listenerListNodes.remove(ChangeListener.class, l);
    }

    protected void fireStateChangedNodes() {
        Object[] listeners = this.listenerListNodes.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Dimension getSize() {
        int maxX = 0;
        int maxY = 0;
        for (Point node : this.points) {
            if (node.getX() > (double)maxX) {
                maxX = (int)node.getX();
            }
            if (!(node.getY() > (double)maxY)) continue;
            maxY = (int)node.getY();
        }
        return new Dimension(maxX + 50, maxY + 50);
    }

    public void rotate(Point center, double degrees) {
        double xC = center.getX();
        double yC = center.getY();
        double rad = degrees * Math.PI / 180.0;
        double c = Math.cos(rad);
        double s = Math.sin(rad);
        ListIterator it = this.points.listIterator();
        while (it.hasNext()) {
            Point p = (Point)it.next();
            double x = p.getX();
            double y = p.getY();
            double nX = (x - xC) * c - (y - yC) * s + xC;
            double nY = (x - xC) * s + (y - yC) * c + yC;
            p.set(nX, nY);
        }
        this.fireStateChangedPoints();
    }

    public void rotateLeft(Point center) {
        this.rotate(center, 90.0);
    }

    public void rotateRight(Point center) {
        this.rotate(center, -90.0);
    }

    public void cleanNodes() {
        this.nodes = new LinkedList();
    }
}

