/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Document
extends JInternalFrame
implements ChangeListener,
InternalFrameListener,
Printable,
Pageable,
VetoableChangeListener {
    public static final int LEFT = 10;
    public static final Color tempColor2 = Color.red;
    private boolean newdoc;
    private boolean saved;
    private boolean changed;
    private Data data;
    private File file;
    private String title;
    private Stack undo = new Stack();
    private Stack redo = new Stack();
    private GraphPanel drawPanel;
    private NodePanel nodePanel;
    private GraphFrame graphFrame;
    private boolean hulpConstructie = false;
    private static final Dimension DEFAULTSIZE = new Dimension(640, 480);
    private static final String NEWFILE = "New document";
    private Algoritme algo;
    private Environment environment;
    private boolean showNodesVector = false;
    private boolean showNodes = false;
    private boolean showBezier = false;
    private boolean closeCurrent = true;
    private PageFormat pageFormat;
    private Rectangle curveScope = new Rectangle(0, 0, 0, 0);
    private Rectangle pointScope = new Rectangle(0, 0, 0, 0);
    private Rectangle hulpScope = new Rectangle(0, 0, 0, 0);
    private double hulpT = -1.0;
    private boolean drag = false;

    private Document(GraphFrame frame) {
        super(NEWFILE, true, true, true, true);
        this.environment = frame.getEnvironment();
        this.graphFrame = frame;
        this.title = this.title;
        this.newdoc = true;
        this.saved = false;
        this.changed = false;
        this.data = new Data();
        this.data.addChangeListener(this);
        this.makeContent();
        this.setSize(DEFAULTSIZE);
        this.addInternalFrameListener(this);
        this.addVetoableChangeListener(this);
        this.updateTitle();
    }

    private Document(GraphFrame frame, File file) {
        super(file.getName(), true, true, true, true);
        this.file = file;
        this.environment = frame.getEnvironment();
        this.graphFrame = frame;
        this.title = file.getName();
        this.newdoc = false;
        this.saved = true;
        this.changed = false;
        this.data = new Data();
        try {
            this.data.load(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.data.addChangeListener(this);
        this.data.update();
        this.makeContent();
        this.setSize(DEFAULTSIZE);
        this.addInternalFrameListener(this);
        this.addVetoableChangeListener(this);
        this.changed = false;
        this.updateTitle();
    }

    private void makeContent() {
        this.drawPanel = new GraphPanel(this);
        this.nodePanel = new NodePanel(this);
        JScrollPane scroll = new JScrollPane(this.drawPanel);
        JLabel[] corners = new JLabel[4];
        for (int i = 0; i < 4; ++i) {
            corners[i] = new JLabel((String)null, 0);
            corners[i].setBackground(Color.orange);
            corners[i].setOpaque(true);
        }
        corners[2].setText("px");
        JLabel rowheader = new JLabel(){
            Font f = new Font("Serif", 3, 10);

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle r = g.getClipBounds();
                g.setFont(this.f);
                g.setColor(Color.black);
                for (int i = 30 - r.y % 30; i < r.height; i += 30) {
                    g.drawLine(0, r.y + i, 3, r.y + i);
                    g.drawString("" + (r.y + i), 6, r.y + i + 3);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(25, Document.this.drawPanel.getHeight());
            }
        };
        rowheader.setBackground(Color.orange);
        rowheader.setOpaque(true);
        JLabel columnheader = new JLabel(){
            Font f = new Font("Serif", 3, 10);

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle r = g.getClipBounds();
                g.setFont(this.f);
                g.setColor(Color.black);
                for (int i = 30 - r.x % 30; i < r.width; i += 30) {
                    g.drawLine(r.x + i, 0, r.x + i, 3);
                    g.drawString("" + (r.x + i), r.x + i - 10, 16);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(Document.this.drawPanel.getWidth(), 25);
            }
        };
        columnheader.setBackground(Color.orange);
        columnheader.setOpaque(true);
        scroll.setRowHeaderView(rowheader);
        scroll.setColumnHeaderView(columnheader);
        scroll.setCorner("LOWER_LEFT_CORNER", corners[0]);
        scroll.setCorner("LOWER_RIGHT_CORNER", corners[1]);
        scroll.setCorner("UPPER_LEFT_CORNER", corners[2]);
        scroll.setCorner("UPPER_RIGHT_CORNER", corners[3]);
        JPanel c = new JPanel(new BorderLayout());
        c.add((Component)scroll, "Center");
        c.add((Component)this.nodePanel, "South");
        this.setContentPane(c);
    }

    public static Document load(GraphFrame frame, File file) throws DocumentFormatException, IOException {
        return new Document(frame, file);
    }

    public static Document createNew(GraphFrame frame) {
        return new Document(frame);
    }

    public void createUndoable() {
        this.changed = true;
        this.updateTitle();
        Data clone = (Data)this.data.clone();
        this.undo.push(clone);
        this.redo.clear();
        this.graphFrame.refresh();
    }

    public void createUndoable(Data data) {
        this.changed = true;
        this.updateTitle();
        this.undo.push(data);
        this.redo.clear();
        this.graphFrame.refresh();
    }

    public boolean canUndo() {
        return !this.undo.isEmpty();
    }

    public boolean canRedo() {
        return !this.redo.isEmpty();
    }

    public Data undo() {
        if (this.undo.isEmpty()) {
            return null;
        }
        Data clone = (Data)this.data.clone();
        this.redo.push(clone);
        Data prev = (Data)this.undo.pop();
        this.data.copyListeners(prev);
        this.data = prev;
        if (this.algo != null) {
            this.algo.setData(this.data);
        }
        this.repaint();
        this.graphFrame.refresh();
        return this.data;
    }

    public Data undoWithoutRedo() {
        if (this.undo.isEmpty()) {
            return null;
        }
        Data prev = (Data)this.undo.pop();
        this.data.copyListeners(prev);
        this.data = prev;
        if (this.algo != null) {
            this.algo.setData(this.data);
        }
        this.repaint();
        this.graphFrame.refresh();
        return this.data;
    }

    public Data redo() {
        if (this.redo.isEmpty()) {
            return null;
        }
        Data clone = (Data)this.data.clone();
        this.undo.push(clone);
        Data next = (Data)this.redo.pop();
        this.data.copyListeners(next);
        this.data = next;
        if (this.algo != null) {
            this.algo.setData(this.data);
        }
        this.repaint();
        this.graphFrame.refresh();
        return next;
    }

    public void save(File file) throws IOException {
        this.file = file;
        this.data.save(file);
        this.title = file.getName();
        this.changed = false;
        this.updateTitle();
    }

    public boolean save() throws IOException {
        if (this.file == null) {
            JFileChooser dialog = new JFileChooser();
            dialog.setFileFilter(new ExtensionFilter(".gt"));
            if (dialog.showDialog(this, "Bestand opslaan") == 0) {
                String f = dialog.getSelectedFile().toString();
                if (!f.endsWith(".gt")) {
                    f = f + ".gt";
                }
                this.file = new File(f);
            } else {
                return false;
            }
        }
        this.save(this.file);
        return true;
    }

    public boolean saveAs() throws IOException {
        JFileChooser dialog = new JFileChooser();
        dialog.setFileFilter(new ExtensionFilter(".gt"));
        if (dialog.showDialog(this, "Bestand opslaan") != 0) {
            return false;
        }
        String f = dialog.getSelectedFile().toString();
        if (!f.endsWith(".gt")) {
            f = f + ".gt";
        }
        this.save(new File(f));
        return true;
    }

    public boolean close() throws IOException {
        try {
            this.setClosed(true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean closeDialog() throws IOException {
        if (this.changed) {
            Object[] opties = new String[]{"Ja", "Nee"};
            int optie = JOptionPane.showOptionDialog(this, "Wenst u het document op te slaan?", "Openen", -1, 3, null, opties, opties[0]);
            if (optie == 0) {
                return this.save();
            }
            return optie == 1;
        }
        return true;
    }

    public void zoomIn() {
        if (this.drawPanel.getMode() != 10) {
            this.drawPanel.setMode(10);
            this.drawPanel.startSearchCenter();
        } else {
            this.drawPanel.setMode(1);
            this.drawPanel.stopSearchCenter();
        }
    }

    public void zoomOut() {
        if (this.drawPanel.getMode() != 11) {
            this.drawPanel.setMode(11);
            this.drawPanel.startSearchCenter();
        } else {
            this.drawPanel.setMode(1);
            this.drawPanel.stopSearchCenter();
        }
    }

    public void zoomCustom() {
        if (this.drawPanel.getMode() != 12) {
            this.drawPanel.setMode(12);
            this.drawPanel.startSearchCenter();
        } else {
            this.drawPanel.setMode(1);
            this.drawPanel.stopSearchCenter();
        }
    }

    public void zoomRectangle() {
        if (this.drawPanel.getMode() != 13) {
            this.drawPanel.setMode(13);
        } else {
            this.drawPanel.setMode(1);
        }
    }

    public void zoom(double zoom) {
        this.data.restoreOriginalScale();
        Point p = new Point(0.0, 0.0);
        this.data.zoom(p, zoom, zoom);
    }

    public void rotate() {
        if (this.drawPanel.getMode() != 14) {
            this.drawPanel.setMode(14);
            this.drawPanel.startSearchCenter();
        } else {
            this.drawPanel.setMode(1);
            this.drawPanel.stopSearchCenter();
        }
    }

    public void setShowHulpConstructie(boolean show) {
        this.hulpConstructie = show;
        if (this.hulpConstructie) {
            this.nodePanel.startSearchHulpT();
            this.drawPanel.startSearchHulpPoint();
        }
        this.setHulpT(-1.0);
    }

    public boolean getShowHulpConstructie() {
        return this.hulpConstructie;
    }

    public boolean canDrawHulpConstructie() {
        return this.data.getPointsCount() >= 2 && this.algo != null;
    }

    public void refresh() {
        this.graphFrame.refresh();
    }

    public boolean isNew() {
        return this.newdoc;
    }

    public Data getData() {
        return this.data;
    }

    public Algoritme getAlgoritme() {
        return this.algo;
    }

    public GraphPanel getDrawPanel() {
        return this.drawPanel;
    }

    private void updateTitle() {
        this.setTitle(this.title + (this.changed ? " *" : ""));
    }

    public void updateTitle(String title) {
        this.title = title;
        this.setTitle(title + (this.changed ? " *" : ""));
    }

    public void showNodesVector(boolean show) {
        this.showNodesVector = show;
        this.nodePanel.setVisible(this.showNodesVector);
    }

    public boolean getShowNodesVector() {
        return this.showNodesVector;
    }

    public void showNodes(boolean show) {
        this.showNodes = show;
        this.repaint();
    }

    public boolean getShowNodes() {
        return this.showNodes;
    }

    public void showBezier(boolean show) {
        this.showBezier = show;
        this.repaint();
    }

    public boolean getShowBezier() {
        return this.showBezier;
    }

    public void increaseOrder() {
        if (this.algo instanceof BSpline) {
            this.createUndoable();
            ((BSpline)this.algo).increaseOrder();
            this.repaint();
        }
    }

    public void halveer() {
        this.createUndoable();
        this.algo.halveer();
        this.repaint();
    }

    public void verdeelUniform() {
        this.createUndoable();
        this.algo.verdeelUniform();
        this.repaint();
    }

    public void verdeelOpenUniform() {
        this.createUndoable();
        this.algo.verdeelOpenUniform();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        this.nodePanel.setVisible(this.showNodesVector);
    }

    public void stateChanged(ChangeEvent e) {
        this.changed = true;
        this.updateTitle();
        this.graphFrame.refresh();
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.graphFrame.refresh();
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        this.graphFrame.refresh();
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.graphFrame.refresh();
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        this.graphFrame.refresh();
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.graphFrame.refresh();
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (!this.graphFrame.isGraphVisible() && pageIndex > 0) {
            return 1;
        }
        if (pageIndex == 0) {
            this.printBasis(g, pageFormat);
        } else if (pageIndex == 1) {
            this.printGraph(g, pageFormat);
        } else {
            return 1;
        }
        return 0;
    }

    public void printBasis(Graphics g, PageFormat pageFormat) {
        g.setColor(Color.black);
        g.setFont(new Font(null, 1, 16));
        int titleWidth = g.getFontMetrics().stringWidth(this.title);
        int titleHeight = g.getFontMetrics().getHeight();
        int w = (int)pageFormat.getImageableWidth();
        int h = (int)pageFormat.getImageableHeight();
        int xTop = (int)pageFormat.getImageableX();
        int yTop = (int)pageFormat.getImageableY();
        g.drawString(this.title, xTop + (w - titleWidth) / 2, yTop + titleHeight);
        g.setFont(new Font(null, 0, 10));
        int MARGIN = 20;
        g.translate(0, yTop + titleHeight + MARGIN);
        this.paintPoints(g);
        this.paintLines(g);
        this.paintCurve(g);
        if (this.showNodes) {
            this.paintNodes(g);
        }
        if (this.showBezier) {
            this.paintBezier(g);
        }
        if (this.hulpConstructie) {
            this.paintHulpConstructie(g);
        }
        g.translate(0, -(yTop + titleHeight + MARGIN));
        if (this.showNodesVector) {
            int wV = w;
            int hV = 50;
            int xV = xTop;
            int yV = yTop + h - hV;
            g.setColor(Color.black);
            g.setFont(new Font(null, 1, 12));
            String vector = "Knopenvector:";
            int vectorWidth = g.getFontMetrics().stringWidth(vector);
            int vectorHeight = g.getFontMetrics().getHeight();
            g.translate(xV, yV - (vectorHeight + MARGIN));
            g.translate(0, vectorHeight + MARGIN);
            g.setColor(Color.black);
            g.drawString(vector, 0, 0);
            g.setFont(new Font(null, 0, 10));
            g.setColor(Color.black);
            this.paintNodesVector(g, wV, hV, true);
        }
    }

    public void printGraph(Graphics g, PageFormat pageFormat) {
        int wG;
        g.setColor(Color.black);
        g.setFont(new Font(null, 1, 16));
        int titleWidth = g.getFontMetrics().stringWidth(this.title);
        int titleHeight = g.getFontMetrics().getHeight();
        int w = (int)pageFormat.getImageableWidth();
        int h = (int)pageFormat.getImageableHeight();
        int xTop = (int)pageFormat.getImageableX();
        int yTop = (int)pageFormat.getImageableY();
        g.drawString(this.title, xTop + (w - titleWidth) / 2, yTop + titleHeight);
        g.setFont(new Font(null, 0, 10));
        int MARGIN = 20;
        g.translate(0, yTop + titleHeight + 2 * MARGIN);
        int hG = wG = 3 * w / 4;
        int xG = xTop;
        int yG = 0;
        g.setColor(Color.black);
        g.setFont(new Font(null, 1, 12));
        String graph = "Gewichtsfuncties:";
        int graphWidth = g.getFontMetrics().stringWidth(graph);
        int graphHeight = g.getFontMetrics().getHeight();
        g.translate(xG, yG - (graphHeight + MARGIN));
        g.translate(0, graphHeight + MARGIN);
        g.setColor(Color.black);
        g.drawString(graph, 0, 0);
        g.setFont(new Font(null, 0, 10));
        g.setColor(Color.black);
        this.paintWeightGraphs(g, xG, yG, wG, hG);
    }

    public int getNumberOfPages() {
        return this.graphFrame.isGraphVisible() ? 2 : 1;
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.pageFormat;
    }

    public Printable getPrintable(int pageIndex) {
        return this;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void paintCurve(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(2.0f));
        if (this.algo == null || !this.algo.isValidData(this.data)) {
            return;
        }
        try {
            int[] y;
            int[] x;
            if (this.drag && !this.graphFrame.getDetailedDrag()) {
                x = this.algo.calculateCurveX(10.0);
                y = this.algo.calculateCurveY(10.0);
            } else {
                x = this.algo.calculateCurveX();
                y = this.algo.calculateCurveY();
            }
            if (x == null || y == null || x.length < 1 || y.length < 1) {
                return;
            }
            this.getCurveRectangle(x, y);
            g.setColor(this.environment.getCurveColor());
            int x0 = x[0];
            int y0 = y[0];
            for (int i = 1; i < x.length; ++i) {
                int x1 = x[i];
                int y1 = y[i];
                g.drawLine(x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }
        catch (NotInitializedException notInitializedException) {
            // empty catch block
        }
    }

    public Rectangle fit() {
        Rectangle scope = this.getScope();
        return scope;
    }

    public Rectangle getScope() {
        Rectangle scope = this.pointScope.union(this.curveScope);
        if (this.hulpConstructie) {
            scope = scope.union(this.hulpScope);
        }
        return scope;
    }

    private void getCurveRectangle(int[] xtab, int[] ytab) {
        int i;
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (i = 0; i < xtab.length; ++i) {
            minX = Math.min(minX, (double)xtab[i]);
            maxX = Math.max(maxX, (double)xtab[i]);
        }
        for (i = 0; i < ytab.length; ++i) {
            minY = Math.min(minY, (double)ytab[i]);
            maxY = Math.max(maxY, (double)ytab[i]);
        }
        this.curveScope = new Rectangle((int)minX, (int)minY, (int)Math.abs(maxX - minX), (int)Math.abs(maxY - minY));
    }

    private void getPointRectangle() {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        Point[] p = this.data.getPoints();
        for (int i = 0; i < p.length; ++i) {
            double x = p[i].getX();
            double y = p[i].getY();
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        this.pointScope = new Rectangle((int)minX, (int)minY, (int)Math.abs(maxX - minX), (int)Math.abs(maxY - minY));
    }

    public void paintPoints(Graphics g) {
        Point[] points = this.data.getPoints();
        if (points == null) {
            return;
        }
        Color[] colors = this.environment.getDefaultColors();
        g.setColor(this.environment.getPointColor());
        for (int i = 0; i < points.length; ++i) {
            Point point = points[i];
            int x = (int)point.getX();
            int y = (int)point.getY();
            int R = this.environment.getNodeRadius();
            if (this.graphFrame.isGraphVisible()) {
                g.setColor(colors[i % colors.length]);
            }
            g.fillOval(x - R / 2, y - R / 2, R, R);
        }
        this.getPointRectangle();
    }

    public void paintLines(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(1.0f));
        Point[] points = this.data.getPoints();
        if (points == null) {
            return;
        }
        int len = points.length;
        int[] x = new int[len];
        int[] y = new int[len];
        for (int i = 0; i < len; ++i) {
            Point point = points[i];
            x[i] = (int)point.getX();
            y[i] = (int)point.getY();
        }
        g.setColor(this.environment.getLineColor());
        g.drawPolyline(x, y, len);
    }

    public void paintNodes(Graphics g) {
        if (this.algo == null || !this.algo.isValidData(this.data)) {
            return;
        }
        Node[] nodes = this.data.getNodes();
        int k = this.data.getOrder();
        int n = nodes.length;
        g.setColor(this.environment.getNodeColor());
        int start = this.algo instanceof Lagrange ? 0 : k - 1;
        int end = this.algo instanceof Lagrange ? n - 1 : n - k;
        for (int i = start; i <= end; ++i) {
            double t = nodes[i].getT();
            Point point = this.algo.calcPoint(t);
            int x = (int)point.getX();
            int y = (int)point.getY();
            int R = this.environment.getNodeRadius();
            g.fillOval(x - R / 2, y - R / 2, R, R);
            t = (double)((int)(t * 100000.0)) / 100000.0;
            g.drawString("t=" + t, x + R, y + R);
        }
    }

    public void setHulpT(double t) {
        this.hulpT = t;
        this.drawPanel.stopSearchHulpPoint();
        this.repaint();
    }

    public void setHulpPoint(Point p) {
        double t = this.algo.getT(p);
        this.setHulpT(t);
    }

    public double getHulpT() {
        return this.hulpT;
    }

    public void paintHulpConstructie(Graphics gg) {
        if (this.algo == null || !this.algo.isValidData(this.data)) {
            return;
        }
        if (this.drag && !this.graphFrame.getDetailedDrag()) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(2.0f));
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        int R = this.environment.getNodeRadius();
        if (this.hulpT < 0.0) {
            return;
        }
        Point[][] p = this.algo.tempConstruct(this.hulpT);
        int n = p.length;
        g.setColor(this.environment.getTempColor());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                Point pA = p[n - i - 1][j];
                int xA = (int)pA.getX();
                int yA = (int)pA.getY();
                g.fillOval(xA - R / 2, yA - R / 2, R, R);
                minX = Math.min(minX, (double)xA);
                maxX = Math.max(maxX, (double)xA);
                minY = Math.min(minY, (double)yA);
                maxY = Math.max(maxY, (double)yA);
                if (i >= n - 1) continue;
                Point pB = p[n - i - 2][j];
                int xB = (int)pB.getX();
                int yB = (int)pB.getY();
                g.drawLine(xA, yA, xB, yB);
                minX = Math.min(minX, (double)xB);
                maxX = Math.max(maxX, (double)xB);
                minY = Math.min(minY, (double)yB);
                maxY = Math.max(maxY, (double)yB);
                Point pC = p[n - i - 2][j + 1];
                int xC = (int)pC.getX();
                int yC = (int)pC.getY();
                g.drawLine(xA, yA, xC, yC);
                minX = Math.min(minX, (double)xC);
                maxX = Math.max(maxX, (double)xC);
                minY = Math.min(minY, (double)yC);
                maxY = Math.max(maxY, (double)yC);
            }
        }
        g.setColor(tempColor2);
        if (n > 0) {
            Point pCurve = p[n - 1][0];
            int xCurve = (int)pCurve.getX();
            int yCurve = (int)pCurve.getY();
            g.fillOval(xCurve - R / 2, yCurve - R / 2, R, R);
            g.setFont(new Font(null, 0, 10));
            double hT = (double)((int)(this.hulpT * 100000.0)) / 100000.0;
            g.drawString("t=" + hT, xCurve + R, yCurve - R);
        }
        this.hulpScope = new Rectangle((int)minX, (int)minY, (int)Math.abs(maxX - minX), (int)Math.abs(maxY - minY));
    }

    public void paintBezier(Graphics gg) {
        if (this.algo == null || !(this.algo instanceof BSpline) || !this.algo.isValidData(this.data)) {
            return;
        }
        if (this.drag && !this.graphFrame.getDetailedDrag()) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(2.0f));
        BSpline b = (BSpline)this.algo;
        Point[] p = b.calcBezier();
        int R = this.environment.getNodeRadius();
        g.setColor(this.environment.getBezierColor());
        int[] xTab = Point.getXarray(p);
        int[] yTab = Point.getYarray(p);
        for (int i = 0; i < p.length; ++i) {
            int x = (int)p[i].getX();
            int y = (int)p[i].getY();
            g.fillOval(x - R / 2, y - R / 2, R, R);
        }
        g.drawPolyline(xTab, yTab, p.length);
    }

    public void paintNodesVector(Graphics g, int w, int h, boolean values) {
        int R = this.environment.getNodeRadius();
        g.setColor(this.environment.getAxColor());
        g.drawLine(10 + R / 2, h / 2, w - 20 + R / 2, h / 2);
        if (!this.algo.isValidData(this.data) && this.algo instanceof BSpline) {
            g.setColor(Color.black);
            String t = "Geen orde ingesteld";
            FontMetrics fm = g.getFontMetrics();
            g.drawString(t, (w - fm.stringWidth(t)) / 2, 10);
            return;
        }
        if (this.hulpT >= 0.0) {
            int[] xTab = new int[3];
            int[] yTab = new int[3];
            int xT = (int)(this.hulpT * (double)(w - 20)) + 10;
            g.setColor(this.environment.getTempColor());
            g.drawLine(xT, 0, xT, h);
            double t = (double)((int)(this.hulpT * 100000.0)) / 100000.0;
            g.setColor(tempColor2);
            g.setFont(new Font(null, 0, 10));
            int xText = xT + 6;
            String text = "t=" + t;
            FontMetrics fm = g.getFontMetrics();
            int textWidth = fm.stringWidth(text);
            if (textWidth + xText > w) {
                xText -= textWidth + 12;
            }
            g.drawString(text, xText, h - 6);
            xTab[0] = xT - 5;
            xTab[1] = xT + 5;
            xTab[2] = xT;
            yTab[0] = 0;
            yTab[1] = 0;
            yTab[2] = 10;
            g.fillPolygon(xTab, yTab, 3);
        }
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        int k = this.data.getOrder();
        if (k < 0) {
            return;
        }
        if (this.algo instanceof BSpline) {
            int i;
            for (i = 0; i < k - 1; ++i) {
                double tl = nodes[i].getT();
                double tr = nodes[n - i - 1].getT();
                int xl = (int)(tl * (double)(w - 20)) + 10;
                int xr = (int)(tr * (double)(w - 20)) + 10;
                g.setColor(this.environment.getVirtualNodeColor());
                g.fillOval(xl - R / 2, h / 2 - R / 2, R, R);
                g.fillOval(xr - R / 2, h / 2 - R / 2, R, R);
                if (values) {
                    g.setColor(Color.black);
                    g.drawString("" + (double)((int)(tl * 10000.0)) / 10000.0, xl - R, h / 2 + 3 * R / 2);
                    g.drawString("" + (double)((int)(tr * 10000.0)) / 10000.0, xr - R, h / 2 + 3 * R / 2);
                }
                g.setColor(Color.black);
                int nL = this.data.countNodes(tl);
                int nR = this.data.countNodes(tr);
                if (nL > 1) {
                    g.drawString(Integer.toString(nL), xl - R / 2, h / 2 - R / 2);
                }
                if (nR <= 1) continue;
                g.drawString(Integer.toString(nR), xr - R / 2, h / 2 - R / 2);
            }
            for (i = k - 1; i <= n - k; ++i) {
                double t = nodes[i].getT();
                int x = (int)(t * (double)(w - 20)) + 10;
                g.setColor(this.environment.getRealNodeColor());
                g.fillOval(x - R / 2, h / 2 - R / 2, R, R);
                if (values) {
                    g.setColor(Color.black);
                    g.drawString("" + (double)((int)(t * 10000.0)) / 10000.0, x - R, h / 2 + 3 * R / 2);
                }
                g.setColor(Color.black);
                int nL = this.data.countNodes(t);
                if (nL <= 1) continue;
                g.drawString(Integer.toString(nL), x - R / 2, h / 2 - R / 2);
            }
        } else {
            g.setColor(this.environment.getRealNodeColor());
            for (int i = 0; i < n; ++i) {
                double t = nodes[i].getT();
                int x = (int)(t * (double)(w - 20)) + 10;
                g.fillOval(x - R / 2, h / 2 - R / 2, R, R);
            }
        }
    }

    public void paintWeightGraphs(Graphics gg, int x, int y, int w, int h) {
        int height;
        int j;
        if (this.algo == null) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(2.0f));
        Color[] colors = this.environment.getDefaultColors();
        double[][] functies = this.algo.calcGraphs(0.0, 1.0, 1.0 / (double)(w - 10));
        if (this.algo instanceof Lagrange) {
            double minY = 0.0;
            double maxY = 0.0;
            for (int i = 0; i < functies.length; ++i) {
                for (j = 0; j < functies[i].length; ++j) {
                    double f = functies[i][j];
                    minY = Math.min(minY, f);
                    maxY = Math.max(maxY, f);
                }
            }
            double scale = Math.abs(maxY) + Math.abs(minY);
            height = (int)((double)h / (2.0 * scale));
        } else {
            height = h - 20;
        }
        g.setColor(this.environment.getAxColor());
        g.translate(x, 0);
        g.drawLine(10, 0, 10, h);
        if (this.hulpT >= 0.0) {
            g.setColor(this.environment.getTempColor());
            int xHulp = 10 + (int)(this.hulpT * (double)(w - 10));
            g.drawLine(xHulp, 0, xHulp, h);
        }
        if (this.algo instanceof Lagrange) {
            g.translate(0, y + h / 2);
            g.drawLine(0, -height, 10, -height);
        } else {
            g.translate(0, y + h - 10);
        }
        g.drawLine(0, height, 10, height);
        g.setColor(this.environment.getAxColor());
        g.drawLine(0, 0, w, 0);
        g.translate(10, 0);
        for (int i = 0; i < functies.length; ++i) {
            g.setColor(colors[i % colors.length]);
            double[] tab = functies[i];
            int len = tab.length;
            int[] xTab = new int[len];
            int[] yTab = new int[len];
            for (j = 0; j < len; ++j) {
                xTab[j] = j;
                yTab[j] = -((int)(tab[j] * (double)height));
            }
            g.drawPolyline(xTab, yTab, len);
        }
        if (this.algo instanceof BSpline) {
            int i;
            Node[] nodes = this.data.getNodes();
            int k = this.data.getOrder();
            int n = nodes.length;
            if (k <= 0) {
                return;
            }
            for (i = 0; i < k - 1; ++i) {
                double tl = nodes[i].getT();
                double tr = nodes[n - i - 1].getT();
                int xl = (int)(tl * (double)(w - 10));
                int xr = (int)(tr * (double)(w - 10));
                g.setColor(this.environment.getVirtualNodeColor());
                g.drawLine(xl, 0, xl, 10);
                g.drawLine(xr, 0, xr, 10);
            }
            for (i = k - 1; i <= n - k; ++i) {
                double t = nodes[i].getT();
                int xr = (int)(t * (double)(w - 10));
                g.setColor(this.environment.getRealNodeColor());
                g.drawLine(xr, 0, xr, 10);
                if (i != k - 1 && i != n - k) continue;
                g.setColor(this.environment.getAxColor());
                g.drawLine(xr, 0, xr, -h + 10);
            }
        }
    }

    public void setLocationText(String text, boolean special) {
        this.graphFrame.setLocationText(text, special);
    }

    public void tekenLagrange() {
        this.algo = new Lagrange(this.data);
        this.repaint();
    }

    public void tekenBSpline() {
        OrderDialog dialog = new OrderDialog((Frame)this.graphFrame, this);
        while (dialog.showDialog()) {
        }
        this.data.setOrder(dialog.getValue());
        this.algo = new BSpline(this.data);
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        int k = this.data.getOrder();
        if (this.hulpConstructie && (this.hulpT < nodes[k - 1].getT() || this.hulpT > nodes[n - k].getT())) {
            this.setHulpT(-1.0);
            this.hulpConstructie = false;
            this.graphFrame.refresh();
        }
        this.repaint();
    }

    public void startDrag() {
        this.drag = true;
    }

    public void stopDrag() {
        this.drag = false;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public GraphFrame getGraphFrame() {
        return this.graphFrame;
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (e.getPropertyName().equals("closed")) {
            try {
                if (!this.closeDialog()) {
                    this.closeCurrent = false;
                    throw new PropertyVetoException("cancel", null);
                }
                this.closeCurrent = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

