/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

class GraphActions {
    public Action newAction;
    public Action openAction;
    public Action saveAction;
    public Action saveAsAction;
    public Action closeAction;
    public Action exitAction;
    public Action printAction;
    public Action undoAction;
    public Action redoAction;
    public Action zoomInAction;
    public Action zoomOutAction;
    public Action zoomCustomAction;
    public Action zoomRectangleAction;
    public Action zoom50Action;
    public Action zoom100Action;
    public Action zoom200Action;
    public Action zoom400Action;
    public Action showGraphAction;
    public Action showNodesVectorAction;
    public Action showNodesAction;
    public Action showHulpconstructieAction;
    public Action showBezierAction;
    public Action rotateFreeAction;
    public Action lagrangeAction;
    public Action bSplineAction;
    public Action detailedDragAction;
    public Action windowsAction;
    public Action javaAction;
    public Action aboutAction;
    public Action helpAction;
    public Action settingsAction;
    public Action increaseOrderAction;
    public Action halveerAction;
    public Action verdeelUniformAction;
    public Action verdeelOpenUniformAction;
    public JMenu windowMenu;
    public JMenu zoomMenu;
    public JCheckBoxMenuItem showGraphMenu;
    public JCheckBoxMenuItem showNodesVectorMenu;
    public JCheckBoxMenuItem showNodesMenu;
    public JCheckBoxMenuItem showBezierMenu;
    public JCheckBoxMenuItem showHulpMenu;
    public JCheckBoxMenuItem detailedDragMenu;
    public JToggleButton btnZoomIn;
    public JToggleButton btnZoomOut;
    public JToggleButton btnZoomRectangle;
    public JToggleButton btnRotate;
    public JToggleButton btnShowGraph;
    public JToggleButton btnShowNodesVector;
    public JToggleButton btnShowNodes;
    public JToggleButton btnShowBezier;
    public JToggleButton btnShowHulp;
    public JToggleButton btnLagrange;
    public JToggleButton btnBSpline;
    public JToggleButton btnNoAlgo;
    private GraphFrame frame;

    public GraphActions(GraphFrame frame) {
        this.frame = frame;
        this.newAction = new NewAction("Nieuw", new ImageIcon("neww20.gif"), "Nieuwe document", new Integer(78));
        this.openAction = new OpenAction("Open...", new ImageIcon("openw20.gif"), "Open", new Integer(79));
        this.saveAsAction = new SaveAsAction("Opslaan als...", new ImageIcon("savew20.gif"), "Opslaan", new Integer(65));
        this.saveAction = new SaveAction("Opslaan...", new ImageIcon("savew20.gif"), "Opslaan als", new Integer(83));
        this.closeAction = new CloseAction("Sluiten", new ImageIcon("closew20.gif"), "Sluiten", new Integer(84));
        this.exitAction = new ExitAction("Exit", new ImageIcon("stopw20.gif"), "Afsluiten", new Integer(69));
        this.printAction = new PrintAction("Afdrukken", new ImageIcon("printw20.gif"), "Afdrukken", new Integer(68));
        this.undoAction = new UndoAction("Undo", new ImageIcon("undow20.gif"), "Ongedaan maken", new Integer(85));
        this.redoAction = new RedoAction("Redo", new ImageIcon("redow20.gif"), "Herdoen", new Integer(82));
        this.increaseOrderAction = new IncreaseOrderAction("Verhoog orde", new ImageIcon("incorderw20.gif"), "Verhoog orde", new Integer(86));
        this.halveerAction = new HalveerAction("Halveer segmenten", new ImageIcon("halveerw20.gif"), "Halveer segment", new Integer(72));
        this.verdeelUniformAction = new VerdeelUniformAction("Verdeel uniform", new ImageIcon("uniformw20.gif"), "Verdeel knopen uniform", new Integer(85));
        this.verdeelOpenUniformAction = new VerdeelOpenUniformAction("Verdeel open uniform", new ImageIcon("openuniformw20.gif"), "Verdeel knopen open uniform", new Integer(79));
        this.zoomInAction = new ZoomInAction("Zoom in", new ImageIcon("zoominw20.gif"), "Zoom in (vanuit punt)", new Integer(73));
        this.zoomOutAction = new ZoomOutAction("Zoom uit", new ImageIcon("zoomoutw20.gif"), "Zoom uit (vanuit punt)", new Integer(85));
        this.zoomCustomAction = new ZoomCustomAction("Zoom vrij", new ImageIcon("zoomw20.gif"), "Zoom vrij (vanuit punt)", new Integer(90));
        this.zoomRectangleAction = new ZoomRectangleAction("Zoom kader", new ImageIcon("zoomkadw20.gif"), "Zoom kader", new Integer(82));
        this.zoom50Action = new Zoom50Action("Zoom 50%", new ImageIcon("zoom05w20.gif"), "Zoom 50% (uit oorsprong)", new Integer(53));
        this.zoom100Action = new Zoom100Action("Zoom 100%", new ImageIcon("zoom1w20.gif"), "Zoom 100% (origineel)", new Integer(49));
        this.zoom200Action = new Zoom200Action("Zoom 200%", new ImageIcon("zoom2w20.gif"), "Zoom 200% (uit oorsprong)", new Integer(50));
        this.zoom400Action = new Zoom400Action("Zoom 400%", new ImageIcon("zoom4w20.gif"), "Zoom 400% (uit oorsprong)", new Integer(52));
        this.showNodesAction = new ShowNodesAction("Toon knooppunten in tekenvenster", new ImageIcon("vensterknop.gif"), "Knooppunten weergeven", new Integer(75));
        this.showNodesVectorAction = new ShowNodesVectorAction("Toon knopenvector", new ImageIcon("nodesw20.gif"), "Knopenvector weergeven", new Integer(86));
        this.showGraphAction = new ShowGraphAction("Toon gewichtsfuncties", new ImageIcon("curvew20.gif"), "Toon gewichtsfuncties", new Integer(71));
        this.showHulpconstructieAction = new ShowHulpconstructieAction("Toon hulpconstructie", new ImageIcon("hulpw20.gif"), "Toon hulpconstructie", new Integer(72));
        this.showBezierAction = new ShowBezierAction("Toon B\u00e9zierrepresentatie", new ImageIcon("bezierw20.gif"), "Toon B\u00e9zierrepresentatie", new Integer(66));
        this.rotateFreeAction = new RotateFreeAction("Roteer vrij", new ImageIcon("rotatew20.gif"), "Roteer over gekozen hoek rond gekozen centrum", new Integer(82));
        this.detailedDragAction = new DetailedDragAction("Gedetailleerd slepen", new ImageIcon("detailw20.gif"), "Gedetailleerd slepen", new Integer(68));
        this.windowsAction = new WindowsAction("Standaard look-and-feel", new ImageIcon("windowsw20.gif"), "Standaard look-and-feel (volgens systeem)", new Integer(87));
        this.javaAction = new JavaAction("Java look-and-feel", new ImageIcon("javaw20.gif"), "Java desktop interface (cross-platform)", new Integer(74));
        this.settingsAction = new SettingsAction("Instellingen", new ImageIcon("propertw20.gif"), "Grafische omgeving instellen", new Integer(73));
        this.lagrangeAction = new LagrangeAction("Teken Lagrange", new ImageIcon("lagrange.gif"), "Teken Lagrange", new Integer(76));
        this.bSplineAction = new BSplineAction("Teken B-spline", new ImageIcon("bspline.gif"), "Teken B-spline", new Integer(66));
        this.aboutAction = new AboutAction("Informatie...", new ImageIcon("infow20.gif"), "Over dit programma", new Integer(73));
        this.helpAction = new HelpAction("Handleiding", new ImageIcon("helpw20.gif"), "Digitale handleiding (internet)", new Integer(72));
        this.windowMenu = new JMenu("Vensters");
    }

    public JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        menubar.add(this.createViewMenu());
        menubar.add(this.createAlgoritmeMenu());
        menubar.add(this.windowMenu);
        menubar.add(this.createHelpMenu());
        return menubar;
    }

    public JToolBar createToolBar() {
        JToolBar tools = new JToolBar();
        tools.add(this.newAction);
        tools.add(this.openAction);
        tools.add(this.saveAction);
        tools.add(this.closeAction);
        tools.add(this.printAction);
        tools.add(Box.createHorizontalStrut(5));
        tools.add(this.settingsAction);
        tools.add(Box.createHorizontalStrut(5));
        tools.add(this.undoAction);
        tools.add(this.redoAction);
        tools.add(Box.createHorizontalStrut(5));
        this.btnShowNodesVector = new JToggleButton(this.showNodesVectorAction);
        this.btnShowNodesVector.setText(null);
        tools.add(this.btnShowNodesVector);
        this.btnShowNodes = new JToggleButton(this.showNodesAction);
        this.btnShowNodes.setText(null);
        tools.add(this.btnShowNodes);
        this.btnShowGraph = new JToggleButton(this.showGraphAction);
        this.btnShowGraph.setText(null);
        tools.add(this.btnShowGraph);
        this.btnShowHulp = new JToggleButton(this.showHulpconstructieAction);
        this.btnShowHulp.setText(null);
        tools.add(this.btnShowHulp);
        this.btnShowBezier = new JToggleButton(this.showBezierAction);
        this.btnShowBezier.setText(null);
        tools.add(this.btnShowBezier);
        tools.add(Box.createHorizontalStrut(5));
        tools.add(this.halveerAction);
        tools.add(this.verdeelUniformAction);
        tools.add(this.verdeelOpenUniformAction);
        tools.add(this.increaseOrderAction);
        tools.add(Box.createHorizontalStrut(5));
        this.btnZoomIn = new JToggleButton(this.zoomInAction);
        this.btnZoomIn.setText(null);
        tools.add(this.btnZoomIn);
        this.btnZoomOut = new JToggleButton(this.zoomOutAction);
        this.btnZoomOut.setText(null);
        tools.add(this.btnZoomOut);
        this.btnZoomRectangle = new JToggleButton(this.zoomRectangleAction);
        this.btnZoomRectangle.setText(null);
        tools.add(this.btnZoomRectangle);
        tools.add(Box.createHorizontalStrut(5));
        this.btnRotate = new JToggleButton(this.rotateFreeAction);
        this.btnRotate.setText(null);
        tools.add(this.btnRotate);
        tools.add(Box.createHorizontalStrut(5));
        ButtonGroup algoGroup = new ButtonGroup();
        this.btnLagrange = new JToggleButton(this.lagrangeAction);
        this.btnLagrange.setText(null);
        tools.add(this.btnLagrange);
        this.btnBSpline = new JToggleButton(this.bSplineAction);
        this.btnBSpline.setText(null);
        algoGroup.add(this.btnLagrange);
        algoGroup.add(this.btnBSpline);
        this.btnNoAlgo = new JToggleButton();
        algoGroup.add(this.btnNoAlgo);
        tools.add(this.btnLagrange);
        tools.add(this.btnBSpline);
        tools.setFloatable(false);
        tools.setVisible(true);
        return tools;
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("Bestand");
        menu.setMnemonic('B');
        JMenuItem nieuw = new JMenuItem(this.newAction);
        nieuw.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        menu.add(nieuw);
        JMenuItem open = new JMenuItem(this.openAction);
        open.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menu.add(open);
        JMenuItem save = new JMenuItem(this.saveAction);
        save.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menu.add(save);
        menu.add(new JMenuItem(this.saveAsAction));
        JMenuItem close = new JMenuItem(this.closeAction);
        close.setAccelerator(KeyStroke.getKeyStroke(115, 2, false));
        menu.add(close);
        menu.addSeparator();
        JMenuItem print = new JMenuItem(this.printAction);
        print.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        menu.add(print);
        menu.addSeparator();
        JMenuItem exit = new JMenuItem(this.exitAction);
        exit.setAccelerator(KeyStroke.getKeyStroke(115, 8, false));
        menu.add(exit);
        return menu;
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Bewerken");
        menu.setMnemonic('w');
        JMenuItem undo = new JMenuItem(this.undoAction);
        undo.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
        menu.add(undo);
        JMenuItem redo = new JMenuItem(this.redoAction);
        redo.setAccelerator(KeyStroke.getKeyStroke(89, 2, false));
        menu.add(redo);
        menu.addSeparator();
        JMenuItem halveer = new JMenuItem(this.halveerAction);
        halveer.setAccelerator(KeyStroke.getKeyStroke(120, 0, false));
        menu.add(halveer);
        JMenuItem uniform = new JMenuItem(this.verdeelUniformAction);
        uniform.setAccelerator(KeyStroke.getKeyStroke(118, 0, false));
        menu.add(uniform);
        JMenuItem openuniform = new JMenuItem(this.verdeelOpenUniformAction);
        openuniform.setAccelerator(KeyStroke.getKeyStroke(119, 0, false));
        menu.add(openuniform);
        JMenuItem increaseOrde = new JMenuItem(this.increaseOrderAction);
        increaseOrde.setAccelerator(KeyStroke.getKeyStroke(73, 2, false));
        menu.add(increaseOrde);
        return menu;
    }

    protected JMenu createAlgoritmeMenu() {
        JMenu menu = new JMenu("Modus");
        menu.setMnemonic('M');
        JMenuItem lagrange = new JMenuItem(this.lagrangeAction);
        lagrange.setAccelerator(KeyStroke.getKeyStroke(113, 0, false));
        menu.add(lagrange);
        JMenuItem bspline = new JMenuItem(this.bSplineAction);
        bspline.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        menu.add(bspline);
        return menu;
    }

    protected JMenu createViewMenu() {
        JMenu menu = new JMenu("Beeld");
        menu.setMnemonic('d');
        this.createZoomMenu();
        menu.add(this.zoomMenu);
        menu.add(this.rotateFreeAction);
        menu.addSeparator();
        this.showNodesVectorMenu = new JCheckBoxMenuItem(this.showNodesVectorAction);
        this.showNodesVectorMenu.setAccelerator(KeyStroke.getKeyStroke(115, 0, false));
        menu.add(this.showNodesVectorMenu);
        this.showNodesMenu = new JCheckBoxMenuItem(this.showNodesAction);
        this.showNodesMenu.setAccelerator(KeyStroke.getKeyStroke(116, 0, false));
        menu.add(this.showNodesMenu);
        this.showGraphMenu = new JCheckBoxMenuItem(this.showGraphAction);
        this.showGraphMenu.setAccelerator(KeyStroke.getKeyStroke(117, 0, false));
        menu.add(this.showGraphMenu);
        menu.addSeparator();
        this.showHulpMenu = new JCheckBoxMenuItem(this.showHulpconstructieAction);
        this.showHulpMenu.setAccelerator(KeyStroke.getKeyStroke(72, 2, false));
        menu.add(this.showHulpMenu);
        this.showBezierMenu = new JCheckBoxMenuItem(this.showBezierAction);
        this.showBezierMenu.setAccelerator(KeyStroke.getKeyStroke(66, 2, false));
        menu.add(this.showBezierMenu);
        menu.addSeparator();
        this.detailedDragMenu = new JCheckBoxMenuItem(this.detailedDragAction);
        this.detailedDragMenu.setSelected(true);
        menu.add(this.detailedDragMenu);
        menu.addSeparator();
        JRadioButtonMenuItem windows = new JRadioButtonMenuItem(this.javaAction);
        JRadioButtonMenuItem java = new JRadioButtonMenuItem(this.windowsAction);
        ButtonGroup group = new ButtonGroup();
        group.add(windows);
        group.add(java);
        menu.add(windows);
        menu.add(java);
        windows.setSelected(true);
        menu.addSeparator();
        JMenuItem settings = new JMenuItem(this.settingsAction);
        settings.setAccelerator(KeyStroke.getKeyStroke(123, 0, false));
        menu.add(settings);
        return menu;
    }

    protected void createZoomMenu() {
        this.zoomMenu = new JMenu("Zoom");
        this.zoomMenu.setMnemonic('Z');
        this.zoomMenu.setIcon(new ImageIcon("zoomw20.gif"));
        JMenuItem zoomIn = new JMenuItem(this.zoomInAction);
        zoomIn.setAccelerator(KeyStroke.getKeyStroke(107, 2, false));
        this.zoomMenu.add(zoomIn);
        JMenuItem zoomOut = new JMenuItem(this.zoomOutAction);
        zoomOut.setAccelerator(KeyStroke.getKeyStroke(109, 2, false));
        this.zoomMenu.add(zoomOut);
        this.zoomMenu.addSeparator();
        this.zoomMenu.add(new JMenuItem(this.zoom50Action));
        this.zoomMenu.add(new JMenuItem(this.zoom100Action));
        this.zoomMenu.add(new JMenuItem(this.zoom200Action));
        this.zoomMenu.add(new JMenuItem(this.zoom400Action));
        this.zoomMenu.addSeparator();
        this.zoomMenu.add(new JMenuItem(this.zoomCustomAction));
        this.zoomMenu.add(new JMenuItem(this.zoomRectangleAction));
        this.zoomMenu.setEnabled(false);
    }

    protected JMenu createHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic('H');
        JMenuItem help = new JMenuItem(this.helpAction);
        help.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
        menu.add(help);
        menu.addSeparator();
        menu.add(new JMenuItem(this.aboutAction));
        return menu;
    }

    public class VerdeelOpenUniformAction
    extends AbstractAction {
        public VerdeelOpenUniformAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doVerdeelOpenUniform();
        }
    }

    public class VerdeelUniformAction
    extends AbstractAction {
        public VerdeelUniformAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doVerdeelUniform();
        }
    }

    public class HalveerAction
    extends AbstractAction {
        public HalveerAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doHalveer();
        }
    }

    public class IncreaseOrderAction
    extends AbstractAction {
        public IncreaseOrderAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doIncreaseOrder();
        }
    }

    public class SettingsAction
    extends AbstractAction {
        public SettingsAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.showSettings();
        }
    }

    public class HelpAction
    extends AbstractAction {
        public HelpAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.showHelp();
        }
    }

    public class AboutAction
    extends AbstractAction {
        public AboutAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            String tekst = "<html><h2><b>GraphCenter 2003 (Lagrange en B-splines)</b></h2><h3><i>Bart De Smet, Kristof Steurbaut</i></h3><br>Project grafische technieken - 2e kandidatuur informatica UGent - academiejaar 2002-2003</html>";
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(GraphActions.this.frame, tekst, "Informatie...", 0, 1, new ImageIcon("icon.gif"), options, null);
        }
    }

    public class JavaAction
    extends AbstractAction {
        public JavaAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doSetJavaLayout();
        }
    }

    public class WindowsAction
    extends AbstractAction {
        public WindowsAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doSetWindowsLayout();
        }
    }

    public class DetailedDragAction
    extends AbstractAction {
        public DetailedDragAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doDetailedDrag();
        }
    }

    public class BSplineAction
    extends AbstractAction {
        public BSplineAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doBSpline();
        }
    }

    public class LagrangeAction
    extends AbstractAction {
        public LagrangeAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doLagrange();
        }
    }

    public class RotateFreeAction
    extends AbstractAction {
        public RotateFreeAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doRotate();
        }
    }

    public class PrintAction
    extends AbstractAction {
        public PrintAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doPrint();
        }
    }

    public class ShowBezierAction
    extends AbstractAction {
        public ShowBezierAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doShowBezier();
            GraphActions.this.frame.refresh();
        }
    }

    public class ShowHulpconstructieAction
    extends AbstractAction {
        public ShowHulpconstructieAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doShowHulpconstructie();
        }
    }

    public class ShowNodesAction
    extends AbstractAction {
        public ShowNodesAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doShowNodes();
            GraphActions.this.frame.refresh();
        }
    }

    public class ShowNodesVectorAction
    extends AbstractAction {
        public ShowNodesVectorAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doShowNodesVector();
            GraphActions.this.frame.refresh();
        }
    }

    public class ShowGraphAction
    extends AbstractAction {
        public ShowGraphAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doShowGraph();
        }
    }

    public class Zoom400Action
    extends AbstractAction {
        public Zoom400Action(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoom(4.0);
        }
    }

    public class Zoom200Action
    extends AbstractAction {
        public Zoom200Action(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoom(2.0);
        }
    }

    public class Zoom100Action
    extends AbstractAction {
        public Zoom100Action(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoom(1.0);
        }
    }

    public class Zoom50Action
    extends AbstractAction {
        public Zoom50Action(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoom(0.5);
        }
    }

    public class ZoomRectangleAction
    extends AbstractAction {
        public ZoomRectangleAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoomRectangle();
            GraphActions.this.frame.refresh();
        }
    }

    public class ZoomCustomAction
    extends AbstractAction {
        public ZoomCustomAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoomCustom();
        }
    }

    public class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoomOut();
            GraphActions.this.frame.refresh();
        }
    }

    public class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doZoomIn();
            GraphActions.this.frame.refresh();
        }
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doRedo();
        }
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doUndo();
        }
    }

    public class ExitAction
    extends AbstractAction {
        public ExitAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doExit();
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doClose();
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doSaveAs();
        }
    }

    public class SaveAction
    extends AbstractAction {
        public SaveAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doSave();
        }
    }

    public class OpenAction
    extends AbstractAction {
        public OpenAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doOpen();
        }
    }

    public class NewAction
    extends AbstractAction {
        public NewAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            GraphActions.this.frame.doNew();
        }
    }
}

