/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class GraphFrame
extends JFrame
implements ContainerListener,
ComponentListener {
    protected JDesktopPane desktop;
    protected JMenu windowMenu;
    private GraphActions actie;
    private JLabel locator;
    private Environment environment;
    private WeightFrame weightFrame;
    private LinkedList docs = new LinkedList();
    private Document current;
    private int docIndex = 0;
    private int newDocIndex = 1;
    private int docCol = 1;
    private boolean detailedDrag = true;
    private static final int MAXDOC = 25;

    public GraphFrame() {
        super("GraphCenter 1.0 (c) 2003 Bart De Smet, Kristof Steurbaut");
        this.align();
        ImageIcon icon = new ImageIcon("icon.gif");
        this.setIconImage(icon.getImage());
        this.addWindowListener(new DesktopWindowListener());
        this.addComponentListener(this);
        this.actie = new GraphActions(this);
        JMenuBar menu = this.actie.createMenuBar();
        this.windowMenu = this.actie.windowMenu;
        this.setJMenuBar(menu);
        JToolBar toolbar = this.actie.createToolBar();
        this.desktop = new JDesktopPane();
        this.desktop.setDragMode(1);
        this.desktop.addContainerListener(this);
        this.locator = new JLabel("");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel toolPanel = new JPanel(new BorderLayout());
        toolPanel.add((Component)toolbar, "West");
        toolPanel.add((Component)this.locator, "East");
        panel.add((Component)toolPanel, "North");
        panel.add((Component)this.desktop, "Center");
        this.setContentPane(panel);
        this.setVisible(true);
        this.updateWindowMenu();
        this.environment = new GraphicsEnvironment();
        this.environment.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphFrame.this.repaint();
            }
        });
        try {
            this.environment.load("environment.ini");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public boolean isGraphVisible() {
        return this.weightFrame != null;
    }

    public void refresh() {
        this.updateWindowMenu();
        int n = this.openedDocumentsCount();
        if (n == 0) {
            this.current = null;
        }
        JInternalFrame iframe = this.desktop.getSelectedFrame();
        try {
            if (iframe == null && n != 0) {
                this.desktop.getAllFrames()[0].setSelected(true);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (iframe instanceof Document) {
            this.current = (Document)iframe;
        }
        if (this.weightFrame != null) {
            this.weightFrame.setDocument(this.current);
        }
        boolean undo = this.current == null ? false : this.current.canUndo();
        boolean redo = this.current == null ? false : this.current.canRedo();
        this.actie.undoAction.setEnabled(undo);
        this.actie.redoAction.setEnabled(redo);
        this.actie.saveAction.setEnabled(this.current != null);
        this.actie.saveAsAction.setEnabled(this.current != null);
        this.actie.printAction.setEnabled(this.current != null);
        this.actie.closeAction.setEnabled(this.current != null);
        this.actie.zoomInAction.setEnabled(this.current != null);
        this.actie.zoomOutAction.setEnabled(this.current != null);
        this.actie.zoomRectangleAction.setEnabled(this.current != null);
        this.actie.zoomMenu.setEnabled(this.current != null);
        if (this.current != null) {
            this.actie.btnZoomIn.setSelected(this.current.getDrawPanel().getMode() == 10);
            this.actie.btnZoomOut.setSelected(this.current.getDrawPanel().getMode() == 11);
            this.actie.btnZoomRectangle.setSelected(this.current.getDrawPanel().getMode() == 13);
        }
        this.actie.rotateFreeAction.setEnabled(this.current != null);
        if (this.current != null) {
            this.actie.btnRotate.setSelected(this.current.getDrawPanel().getMode() == 14);
        }
        this.actie.lagrangeAction.setEnabled(this.current != null);
        this.actie.bSplineAction.setEnabled(this.current != null && this.current.getData().getPointsCount() >= 2);
        if (this.current != null) {
            Algoritme algo = this.current.getAlgoritme();
            boolean b = algo instanceof BSpline;
            boolean l = algo instanceof Lagrange;
            this.actie.btnNoAlgo.setSelected(true);
            this.actie.btnBSpline.setSelected(b);
            this.actie.btnLagrange.setSelected(l);
        } else {
            this.actie.btnBSpline.setSelected(false);
            this.actie.btnLagrange.setSelected(false);
            this.actie.btnNoAlgo.setSelected(true);
        }
        boolean opened = this.openedDocumentsCount() != 0;
        this.actie.showNodesVectorAction.setEnabled(opened);
        this.actie.showHulpconstructieAction.setEnabled(this.current != null && this.current.canDrawHulpConstructie());
        if (this.current != null) {
            Algoritme algo = this.current.getAlgoritme();
            this.actie.increaseOrderAction.setEnabled(algo != null && algo instanceof BSpline);
            this.actie.verdeelOpenUniformAction.setEnabled(algo != null && algo instanceof BSpline);
            this.actie.halveerAction.setEnabled(algo != null);
            this.actie.verdeelUniformAction.setEnabled(algo != null);
        } else {
            this.actie.halveerAction.setEnabled(false);
            this.actie.verdeelOpenUniformAction.setEnabled(false);
            this.actie.verdeelUniformAction.setEnabled(false);
            this.actie.increaseOrderAction.setEnabled(false);
        }
        this.actie.btnShowGraph.setSelected(this.weightFrame != null);
        this.actie.showGraphMenu.setSelected(this.weightFrame != null);
        if (this.current != null) {
            this.actie.showNodesAction.setEnabled(this.current.getAlgoritme() != null);
            this.actie.showNodesVectorAction.setEnabled(this.current.getAlgoritme() != null);
            this.actie.btnShowNodesVector.setSelected(this.current.getShowNodesVector());
            this.actie.showNodesVectorMenu.setSelected(this.current.getShowNodesVector());
            this.actie.btnShowNodes.setSelected(this.current.getShowNodes());
            this.actie.showNodesMenu.setSelected(this.current.getShowNodes());
        } else {
            this.actie.btnShowNodesVector.setEnabled(false);
            this.actie.btnShowNodesVector.setSelected(false);
            this.actie.btnShowNodes.setEnabled(false);
            this.actie.btnShowNodes.setSelected(false);
            this.actie.showNodesMenu.setEnabled(false);
            this.actie.showNodesMenu.setSelected(false);
        }
        if (this.current != null) {
            this.actie.showBezierAction.setEnabled(this.current.getAlgoritme() instanceof BSpline);
            this.actie.btnShowBezier.setSelected(this.current.getAlgoritme() instanceof BSpline && this.current.getShowBezier());
            this.actie.showBezierMenu.setSelected(this.current.getAlgoritme() instanceof BSpline && this.current.getShowBezier());
        } else {
            this.actie.showBezierAction.setEnabled(false);
            this.actie.btnShowBezier.setSelected(false);
            this.actie.showBezierMenu.setEnabled(false);
        }
        this.actie.btnShowHulp.setEnabled(this.current != null && this.current.canDrawHulpConstructie());
        this.actie.btnShowHulp.setSelected(this.current == null ? false : this.current.getShowHulpConstructie());
    }

    public void showSettings() {
        PropertiesDialog dialog = new PropertiesDialog(this);
        dialog.showDialog();
    }

    public boolean getDetailedDrag() {
        return this.detailedDrag;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void showHelp() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof HelpViewer)) continue;
            try {
                frames[i].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        HelpViewer help = new HelpViewer();
        help.setSize(new Dimension(help.getWidth(), this.desktop.getHeight()));
        this.desktop.add(help);
        help.setLocation(this.desktop.getWidth() - help.getWidth(), 0);
        help.setVisible(true);
    }

    public void setLocationText(String text, boolean special) {
        if (special) {
            this.locator.setFont(new Font(null, 1, 12));
        } else {
            this.locator.setFont(new Font(null, 0, 12));
        }
        this.locator.setText(text);
    }

    public void doNew() {
        if (this.openedDocumentsCount() >= 25) {
            this.showMaxDocsWarning();
            return;
        }
        Document doc = Document.createNew(this);
        int pos = this.getNextPos();
        doc.setLocation(pos, pos);
        doc.updateTitle("Nieuw document (" + this.newDocIndex + ")");
        this.desktop.add(doc);
        doc.setVisible(true);
        ++this.newDocIndex;
        this.updateWindowMenu();
    }

    public void doOpen() {
        if (this.openedDocumentsCount() >= 25) {
            this.showMaxDocsWarning();
            return;
        }
        JFileChooser dialog = new JFileChooser();
        dialog.setFileFilter(new ExtensionFilter(".gt"));
        if (dialog.showDialog(this, "Grafisch project laden") != 0) {
            return;
        }
        this.load(dialog.getSelectedFile());
        this.updateWindowMenu();
    }

    public void doSave() {
        JInternalFrame iframe = this.desktop.getSelectedFrame();
        if (iframe instanceof Document) {
            Document doc = (Document)iframe;
            try {
                doc.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doSaveAs() {
        JInternalFrame iframe = this.desktop.getSelectedFrame();
        if (iframe instanceof Document) {
            Document doc = (Document)iframe;
            try {
                doc.saveAs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean doClose() {
        JInternalFrame iframe = this.desktop.getSelectedFrame();
        if (iframe instanceof Document) {
            return this.closeDocument((Document)iframe);
        }
        return true;
    }

    public boolean doCloseAll() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof Document) || this.closeDocument((Document)frames[i])) continue;
            return false;
        }
        return true;
    }

    public void doExit() {
        if (this.doCloseAll()) {
            try {
                this.environment.save("environment.ini");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void doPrint() {
        new PrintingThread(this.current).start();
    }

    public void doUndo() {
        if (this.current != null) {
            this.current.undo();
        }
    }

    public void doRedo() {
        if (this.current != null) {
            this.current.redo();
        }
    }

    public void doZoomIn() {
        if (this.current != null) {
            this.current.zoomIn();
        }
    }

    public void doZoomOut() {
        if (this.current != null) {
            this.current.zoomOut();
        }
    }

    public void doZoomRectangle() {
        if (this.current != null) {
            this.current.zoomRectangle();
        }
    }

    public void doZoomCustom() {
        if (this.current != null) {
            this.current.zoomCustom();
        }
    }

    public void doZoom(double zoom) {
        if (this.current != null) {
            this.current.zoom(zoom);
        }
    }

    public void doRotate() {
        if (this.current != null) {
            this.current.rotate();
        }
        this.refresh();
    }

    public void doShowHulpconstructie() {
        if (this.current != null) {
            this.current.setShowHulpConstructie(!this.current.getShowHulpConstructie());
        }
    }

    public void doShowGraph() {
        if (this.weightFrame == null) {
            JInternalFrame iframe = this.desktop.getSelectedFrame();
            Document document = null;
            if (this.current != null) {
                document = this.current;
            }
            this.weightFrame = new WeightFrame(document);
            this.weightFrame.setLocation(this.desktop.getWidth() - this.weightFrame.getWidth() - 5, 5);
            this.desktop.add(this.weightFrame);
            this.weightFrame.setVisible(true);
        } else {
            try {
                this.weightFrame.setClosed(true);
                this.weightFrame = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.refresh();
        this.repaint();
    }

    public void doShowNodesVector() {
        if (this.current != null) {
            this.current.showNodesVector(!this.current.getShowNodesVector());
        }
    }

    public void doShowNodes() {
        if (this.current != null) {
            this.current.showNodes(!this.current.getShowNodes());
        }
    }

    public void doShowBezier() {
        if (this.current != null && this.current.getAlgoritme() instanceof BSpline) {
            this.current.showBezier(!this.current.getShowBezier());
        }
    }

    public void doDetailedDrag() {
        this.detailedDrag = !this.detailedDrag;
    }

    public void doIncreaseOrder() {
        if (this.current != null && this.current.getAlgoritme() instanceof BSpline) {
            this.current.increaseOrder();
        }
    }

    public void doHalveer() {
        if (this.current != null) {
            this.current.halveer();
        }
    }

    public void doVerdeelUniform() {
        if (this.current != null) {
            this.current.verdeelUniform();
        }
    }

    public void doVerdeelOpenUniform() {
        if (this.current != null) {
            this.current.verdeelOpenUniform();
        }
    }

    public void doLagrange() {
        if (this.current != null) {
            this.current.tekenLagrange();
        }
        this.refresh();
    }

    public void doBSpline() {
        if (this.current != null) {
            this.current.tekenBSpline();
        }
        this.refresh();
    }

    public void doSetWindowsLayout() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doSetJavaLayout() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showMaxDocsWarning() {
        JOptionPane.showMessageDialog(null, "Er zijn te veel vensters geopend.\nOm performantieredenen worden maximaal 25 gelijktijdig geopende documenten toegelaten.\n\nSluit \u00e9\u00e9n of meerdere documenten en probeer opnieuw.", "Performantiewaarschuwing", 0);
    }

    private int getNextPos() {
        if (this.openedDocumentsCount() == 0) {
            this.docIndex = 0;
            this.docCol = 1;
        } else if (this.docIndex == 10) {
            this.docIndex = 0;
            ++this.docCol;
        }
        return 25 * (++this.docIndex - 1) + this.docCol * 10;
    }

    private int openedDocumentsCount() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int n = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof Document)) continue;
            ++n;
        }
        return n;
    }

    private void updateWindowMenu() {
        this.windowMenu.removeAll();
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int n = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof Document)) continue;
            final Document doc = (Document)frames[i];
            JMenuItem item = new JMenuItem();
            item.setAction(new AbstractAction(doc.getTitle(), new ImageIcon("winw20.gif")){

                public void actionPerformed(ActionEvent e) {
                    try {
                        doc.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.windowMenu.add(item);
            ++n;
        }
        this.windowMenu.setEnabled(n != 0);
    }

    private void load(String file) {
        this.load(new File(file));
    }

    private void load(File file) {
        try {
            Document doc = Document.load(this, file);
            this.desktop.add(doc);
            int pos = this.getNextPos();
            doc.setLocation(pos, pos);
            doc.setVisible(true);
        }
        catch (DocumentFormatException ex) {
            JOptionPane.showMessageDialog(this, "Het geselecteerde bestand heeft een ongeldige bestandsindeling en kan niet geladen worden!", "Bestand laden", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Het bestand kon niet gelezen worden!", "Bestand laden", 0);
        }
    }

    private boolean closeDocument(Document document) {
        try {
            boolean closed = document.close();
            this.updateWindowMenu();
            return closed;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void align() {
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
    }

    public void componentAdded(ContainerEvent e) {
        this.updateWindowMenu();
    }

    public void componentRemoved(ContainerEvent e) {
        this.updateWindowMenu();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.weightFrame != null) {
            this.weightFrame.setLocation(this.desktop.getWidth() - this.weightFrame.getWidth() - 5, 5);
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    private class DesktopWindowListener
    extends WindowAdapter {
        private DesktopWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (GraphFrame.this.doCloseAll()) {
                try {
                    GraphFrame.this.environment.save("environment.ini");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        }
    }
}

